/* DisposeWindowAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import be.ugent.caagt.swirl.actions.SimpleAction;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

/**
 * Action which can be used to dispose a window.
 */
public class DisposeWindowAction extends SimpleAction {
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.list.actions.resources");
    
    //
    public void setEnabled(Window window) {
        setEnabled(window!=null);
    }
    
    //
    private Window window;
    
    //
    public void setWindow(Window window) {
        this.window = window;
        setEnabled(window);
    }
    
    /**
     * Create an action of this type for the given window.
     */
    public DisposeWindowAction(Window window) {
        super(BUNDLE, "Close.description", null);
        this.window = window;
        setEnabled(window);
    }
    
    /**
     * Create an action of this type. The window to which
     * this action applies should be set later using {@link #setWindow}.
     */
    public DisposeWindowAction() {
        this(null);
    }
    
    //
    public void actionPerformed(ActionEvent ev) {
        if (window!=null) {
            window.dispose();
        }
    }
}
