<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
  generator.xslt
  =========================================================================
  This file is part of the GrInvIn project - http://www.grinvin.org
  
  Copyright (C) 2005-2008 Universiteit Gent
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  A copy of the GNU General Public License can be found in the file
  LICENSE.txt provided with the source distribution of this program (see
  the META-INF directory in the source jar). This license can also be
  found on the GNU website at http://www.gnu.org/licenses/gpl.html.
  
  If you did not receive a copy of the GNU General Public License along
  with this program, contact the lead developer, or write to the Free
  Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
-->

<!DOCTYPE transform [ <!ENTITY nbsp "&#160;"> ] >

<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:param name="locale"/>
    <xsl:param name="th.name"/>
    <xsl:param name="th.description"/>
    <xsl:param name="css"/>
    <xsl:variable name="locale2" select="substring-before($locale,'_')"/>
    
    <xsl:template match="generator">
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$css}"/>
                <title>
                    <xsl:choose>
                        <xsl:when test="i18n/node[@name=$locale]/properties/entry[@key='generator.name']">
                            <xsl:apply-templates select="i18n/node[@name=$locale]/properties/entry[@key='generator.name']"/>
                        </xsl:when>
                        <xsl:when test="i18n/node[@name=$locale2]/properties/entry[@key='generator.name']">
                            <xsl:apply-templates select="i18n/node[@name=$locale2]/properties/entry[@key='generator.name']"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="i18n/properties/entry[@key='generator.name']"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </title>
            </head>
            <body>
                <h1><img src="svg:{//icon[1]}?size=65"/>&nbsp;
                    <xsl:choose>
                        <xsl:when test="i18n/node[@name=$locale]/properties/entry[@key='generator.name']">
                            <xsl:apply-templates select="i18n/node[@name=$locale]/properties/entry[@key='generator.name']"/>
                        </xsl:when>
                        <xsl:when test="i18n/node[@name=$locale2]/properties/entry[@key='generator.name']">
                            <xsl:apply-templates select="i18n/node[@name=$locale2]/properties/entry[@key='generator.name']"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="i18n/properties/entry[@key='generator.name']"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </h1>
                <xsl:choose>
                    <xsl:when test="i18n/node[@name=$locale]/properties/help">
                        <xsl:apply-templates select="i18n/node[@name=$locale]/properties/help"/>
                    </xsl:when>
                    <xsl:when test="i18n/node[@name=$locale2]/properties/help">
                        <xsl:apply-templates select="i18n/node[@name=$locale2]/properties/help"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="i18n/properties/help"/>
                    </xsl:otherwise>
                </xsl:choose>
                <table border="1" width="100%">
                    <tr>
                        <th><xsl:value-of select="$th.name"/></th>
                        <th><xsl:value-of select="$th.description"/></th>
                    </tr>
                    <xsl:for-each select="parameter">
                        <tr>
                            <td>
                                <xsl:choose>
                                    <xsl:when test="i18n/node[@name=$locale]/properties/entry[@key='parameter.caption']">
                                        <xsl:apply-templates select="i18n/node[@name=$locale]/properties/entry[@key='parameter.caption']"/>
                                    </xsl:when>
                                    <xsl:when test="i18n/node[@name=$locale2]/properties/entry[@key='parameter.caption']">
                                        <xsl:apply-templates select="i18n/node[@name=$locale2]/properties/entry[@key='parameter.caption']"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="i18n/properties/entry[@key='parameter.caption']"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                            <td>
                                <xsl:choose>
                                    <xsl:when test="i18n/node[@name=$locale]/properties/entry[@key='parameter.description']">
                                        <xsl:apply-templates select="i18n/node[@name=$locale]/properties/entry[@key='parameter.description']"/>
                                    </xsl:when>
                                    <xsl:when test="i18n/node[@name=$locale2]/properties/entry[@key='parameter.description']">
                                        <xsl:apply-templates select="i18n/node[@name=$locale2]/properties/entry[@key='parameter.description']"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:apply-templates select="i18n/properties/entry[@key='parameter.description']"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>
                <xsl:apply-templates select="demo"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="help">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="entry[@key='description']">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="entry">
        <xsl:value-of select="."/>
    </xsl:template>
    
    <!-- modified identity template -->
    <xsl:template match="*">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- handles a latex node.

         <latex value="text"/>

         e.g. <latex value="\infty"/>
         
         The value attribute is necessary.

         When a value is present, this returns an object tag with the correct parameter
         otherwise this returns an empty string
    -->
    <xsl:template match="latex">
        <xsl:if test="@value">
            <xsl:variable name="latex">
                <xsl:value-of select="@value"/>
            </xsl:variable>
            <object classid="java:org.grinvin.help.LaTeXViewer">
                <param name="laTeX" value="{$latex}"/>
            </object>
        </xsl:if>
    </xsl:template>
    
    <!-- handles a graph node
    
         <graph name="graphURI" background="RRGGBB" size="pixels"/>

         e.g. <graph name="graph:org.grinvin.factories.CompleteGraphFactory?order=6" background="ff9900" size="250"/>

         Only the name attribute is necessary.
         
         When a name is present, this returns an object tag with the correct parameter
         otherwise this returns an empty string
    -->
    <xsl:template match="graph">
        <xsl:if test="@name">
            <xsl:variable name="name">
                <xsl:value-of select="@name"/>
            </xsl:variable>
            <object classid="java:org.grinvin.help.InlineGraphViewer">
                <param name="graph" value="{$name}"/>
                <xsl:if test="@background">
                    <xsl:variable name="bg">
                        <xsl:value-of select="@background"/>
                    </xsl:variable>
                    <param name="backgroundColor" value="{$bg}"/>
                </xsl:if>
                <xsl:if test="@size">
                    <xsl:variable name="size">
                        <xsl:value-of select="@size"/>
                    </xsl:variable>
                    <param name="displaySize" value="{$size}"/>
                </xsl:if>
            </object>
        </xsl:if>
    </xsl:template>
    
    <!-- handles a link node.

         <link value="id">text</link>

         e.g. <link value="org.grinvin.graphtheory.def.graph">graph</link>
         
         The value attribute is necessary.

         When a value is present and the id is valid, this returns an hyperlink
         to the corresponding subject.
    -->
    <xsl:template match="link">
        <xsl:choose>
            <xsl:when test="@value">
                <xsl:variable name="id" select="@value"/>
                <xsl:variable name="href" select="document('grinvinmap')/map/entry[@key=$id]"/>
                <xsl:choose>
                    <xsl:when test="$href">
                        <a href="{$href}"><xsl:value-of select="."/></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="."/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:transform>
