/* FactoryCellListComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components;

import be.ugent.caagt.swirl.dnd.LocalTransferHandler;
import be.ugent.caagt.swirl.lists.CellList;

import java.util.ResourceBundle;
import javax.swing.ListSelectionModel;

import org.grinvin.factories.graphs.GraphFactory;
import org.grinvin.gui.components.render.GraphFactoryCellRenderer;
import org.grinvin.list.HasSelectableValues;
import org.grinvin.gui.dnd.SelectionDragHandler;
import org.grinvin.list.factories.GraphFactoryListModel;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

/**
 * Cell list component with entries of type {@link GraphFactory}. Provides drag support
 * for factories. Dropping is not allowed.
 */
public class FactoryCellListComponent extends CellList implements HasSelectableValues {
    
    // shared transfer handler
    private static final LocalTransferHandler TRANSFER_HANDLER;
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.list.resources";
    
    static {
        TRANSFER_HANDLER = new LocalTransferHandler();
        TRANSFER_HANDLER.setDragHandler(new SelectionDragHandler(GraphFactory.class));
    }
    
    public FactoryCellListComponent(GraphFactoryListModel model) {
        super(model, GrinvinPreferences.getInstance().getIntPreference(Preference.GRAPHICON_SIZE), GrinvinPreferences.getInstance().getIntPreference(Preference.GRAPHICON_SIZE), 4);
        setTransferHandler(TRANSFER_HANDLER);
        setDragEnabled(true);
        getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        setToolTipText(ResourceBundle.getBundle(BUNDLE_NAME).getString("Factories.name"));
        setCellRenderer(GraphFactoryCellRenderer.getInstance());
    }
    
}
