/*********************************************************************
 *
 *	Copyright (C) 1999 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:     Utilities
 * MODULE:      IntCacheTable Test
 * FILE:        TestIntCacheTable.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      NF      1/9/99          Initial version of TestIntHashtable
 *      nf      10/20/99        Changed to test IntCacheTable
 *
 * DESCRIPTION:
 *      Implements test-wrapper for the IntCacheTable class.
 *
 ********************************************************************/

package com.bluemarsh.util.test;

import com.bluemarsh.util.IntCacheTable;

/**
 * Test-wrapper for the IntCacheTable class.
 *
 * @author  Nathan Fiedler
 * @version 1.0  1/9/99
 */
public class TestIntCacheTable {

    /**
     * Main method, tests the IntCacheTable class.
     *
     * @param  args  command-line string arguments
     */
    public static void main(String[] args) {
        IntCacheTable table = new IntCacheTable();
        // test an emtpy table
        if (table.isEmpty()) {
            System.out.println("Table is empty, good");
        } else {
            System.out.println("Table is not empty, bad");
        }

        // insert 300 elements
        System.out.println("Inserting elements from 1-300...");
        for (int i = 1; i <= 300; i++) {
            // create the key object
            // create a value object that is the reverse of twice the key
            String strObj = String.valueOf(i * 2);
            StringBuffer buf = new StringBuffer(strObj);
            buf.reverse();
            table.put(i, buf.toString());
        }

        // test a full table
        if (table.isEmpty()) {
            System.out.println("Table is empty, bad");
        } else {
            System.out.println("Table is not empty, good");
        }
        System.out.println("Table size = " + table.size());

        // retrieve all 300 elements
        System.out.println("Retrieving all elements from 1-300...");
        for (int i = 1; i <= 300; i++) {
            System.out.print(table.get(i) + ", ");
        }
        // insert a duplicate element (value is different)
        System.out.println("\nInserting new value for key 5...");
        table.put(5, "10");
        System.out.println("Fifth Element: " + table.get(5));
        System.out.println();

        // make a clone of this table
        System.out.println("Making clone of table...");
        IntCacheTable clone = (IntCacheTable)table.clone();

        // remove some elements
        System.out.println("Removing every Fifth Element...");
        for (int i = 5; i <= 300; i += 5) {
            table.remove(i);
        }
        System.out.println("Table size = " + table.size());

        // try to retrieve all 300 elements
        System.out.println("Retrieving all remaining elements...");
        for (int i = 1; i <= 300; i++) {
            Object o = table.get(i);
            if (o != null) {
                System.out.print(o + ", ");
            }
        }
        System.out.println();

        // test full table again
        if (table.isEmpty()) {
            System.out.println("Table is empty, bad");
        } else {
            System.out.println("Table is not empty, good");
        }

        // retrieve all elements from clone table
        System.out.println("Clone size = " + clone.size());
        System.out.println("Retrieving all of clone's elements...");
        for (int i = 1; i <= 300; i++) {
            Object o = clone.get(i);
            if (o != null) {
                System.out.print(o + ", ");
            }
        }
        System.out.println();

        // xxx try to fetch an old element

        // clear tables and test for emptiness
        System.out.println("Clearing both tables...");
        table.clear();
        clone.clear();
        if (table.isEmpty()) {
            System.out.println("Table is empty, good");
        } else {
            System.out.println("Table is not empty, bad");
        }
        System.out.println();

        Runtime rt = Runtime.getRuntime();
        System.out.println("Available memory (bytes): " + rt.freeMemory());
        System.out.println("Calling Runtime.gc()...");
        rt.gc();
        System.out.println("Available memory (bytes): " + rt.freeMemory());

        // Fill the table with 2000 entries and try
        // fetching entries, counting the number of
        // successful and unsuccessful retrievals.
        System.out.println("Inserting elements from 1-100000...");
        for (int i = 1; i <= 100000; i++) {
            table.put(i, String.valueOf(i * 2));
        }

        System.out.println("Retrieving all elements...");
        int good = 0, bad = 0;
        for (int i = 1; i <= 100000; i++) {
            Object o = table.get(i);
            if (o != null) {
                good++;
            } else {
                bad++;
            }
        }
        System.out.println(good + " non-null entries, " + bad +
                           " null entries");
        System.out.println("Available memory (bytes): " + rt.freeMemory());
    } // main
} // TestIntCacheTable
