/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.web.tag;

import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.web.ServletCacheAdministrator;
import com.opensymphony.module.oscache.web.WebEntryRefreshPolicy;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public class CacheTag
extends BodyTagSupport {
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private static final int WEEK = 604800;
    private static final int MONTH = 2592000;
    private static final int YEAR = 31536000;
    private static final String CACHE_TAG_COUNTER_KEY = "__oscache_tag_counter";
    private static final int ONE_MINUTE = 60;
    private static final int ONE_HOUR = 3600;
    private static final int DEFAULT_TIMEOUT = 3600;
    private int cacheScope = 4;
    private Cache cache = null;
    private ServletCacheAdministrator admin = null;
    private String content = null;
    private boolean refresh = false;
    private boolean useBody = true;
    private int time = 3600;
    private String refreshPolicyClass = null;
    private String refreshPolicyParam = null;
    private String key = null;
    private String language = null;

    public int doStartTag() throws JspTagException {
        int n = 2;
        if (this.admin == null) {
            this.admin = ServletCacheAdministrator.getInstance(((TagSupport)this).pageContext.getServletContext());
        }
        this.cache = this.admin.getCache((HttpServletRequest)((TagSupport)this).pageContext.getRequest(), this.cacheScope);
        String string = null;
        if (this.key == null) {
            Object object = ((TagSupport)this).pageContext.getRequest().getAttribute(CACHE_TAG_COUNTER_KEY);
            string = object == null ? "1" : Integer.toString(Integer.parseInt((String)object) + 1);
            ((TagSupport)this).pageContext.getRequest().setAttribute(CACHE_TAG_COUNTER_KEY, (Object)string);
        }
        this.key = this.admin.generateEntryKey(this.key, (HttpServletRequest)((TagSupport)this).pageContext.getRequest(), this.cacheScope, this.language, string);
        try {
            this.content = this.refresh ? (String)this.cache.getFromCache(this.key, 0) : (String)this.cache.getFromCache(this.key, this.time);
            try {
                this.admin.log("<cache>: Using cached entry : " + this.key);
                if (this.content != null) {
                    ((TagSupport)this).pageContext.getOut().write(this.content);
                    n = 0;
                }
            }
            catch (IOException iOException) {
                throw new JspTagException("IO Exception: " + iOException.getMessage());
            }
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.content = (String)needsRefreshException.getCacheContent();
        }
        if (n == 2) {
            this.admin.log("<cache>: Cached content not used: New cache entry, cache staleor scope flushed : " + this.key);
        }
        return n;
    }

    public int doAfterBody() throws JspTagException {
        String string = null;
        try {
            if (this.bodyContent != null && (this.useBody || this.time == 0)) {
                string = this.bodyContent.getString();
                if (this.time > 0 || this.refreshPolicyClass != null) {
                    WebEntryRefreshPolicy webEntryRefreshPolicy = null;
                    if (this.refreshPolicyClass != null) {
                        try {
                            webEntryRefreshPolicy = (WebEntryRefreshPolicy)Class.forName(this.refreshPolicyClass).newInstance();
                            webEntryRefreshPolicy.init(this.key, this.refreshPolicyParam);
                        }
                        catch (Exception exception) {
                            this.admin.log("<cache>: Problem instantiating or initializing refresh policy : " + this.refreshPolicyClass);
                        }
                    }
                    this.admin.log("<cache>: Updating cache entry with new content : " + this.key);
                    this.cache.putInCache(this.key, string, webEntryRefreshPolicy);
                }
            } else if (!this.useBody && this.content != null) {
                this.admin.log("<cache>: Using cached version as instructed, useBody = false : " + this.key);
                string = this.content;
            } else {
                this.admin.log("<cache>: Missing cached content : " + this.key);
                string = "Missing cached content";
            }
            this.bodyContent.clearBody();
            this.bodyContent.write(string);
            this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
        }
        catch (IOException iOException) {
            throw new JspTagException("IO Error: " + iOException.getMessage());
        }
        return 6;
    }

    public int doEndTag() throws JspTagException {
        this.cacheScope = 4;
        this.refresh = false;
        this.useBody = true;
        this.time = 3600;
        this.key = null;
        this.content = null;
        return 6;
    }

    public void setUseBody(boolean bl) {
        this.admin.log("<cache>: Set useBody to " + bl);
        this.useBody = bl;
    }

    public void setScope(String string) {
        this.cacheScope = string.equalsIgnoreCase("session") ? 3 : 4;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public void setDuration(String string) {
        try {
            this.time = this.parseISO_8601_Duration(string);
        }
        catch (Exception exception) {
            try {
                this.time = this.parseDuration(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void setRefreshpolicyclass(String string) {
        this.refreshPolicyClass = string;
    }

    public void setRefreshpolicyparam(String string) {
        this.refreshPolicyParam = string;
    }

    /*
     * Unable to fully structure code
     */
    private int parseDuration(String var1_1) {
        block11: {
            var2_2 = 0;
            try {
                var2_2 = Integer.parseInt(var1_1);
                break block11;
            }
            catch (Exception var3_3) {
                var4_4 = null;
                var5_5 = 0;
                ** while (var5_5 < var1_1.length())
            }
lbl-1000:
            // 1 sources

            {
                if (!Character.isDigit(var1_1.charAt(var5_5))) {
                    var2_2 = Integer.parseInt(var1_1.substring(0, var5_5));
                    switch (var1_1.charAt(var5_5)) {
                        case 's': {
                            var2_2 *= 1;
                            break;
                        }
                        case 'm': {
                            var2_2 *= 60;
                            break;
                        }
                        case 'h': {
                            var2_2 *= 3600;
                            break;
                        }
                        case 'd': {
                            var2_2 *= 86400;
                            break;
                        }
                        case 'w': {
                            var2_2 *= 604800;
                            break;
                        }
                    }
                    break;
                }
                ++var5_5;
                continue;
            }
        }
        return var2_2;
    }

    private int parseISO_8601_Duration(String string) throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = string.indexOf("-");
        if (n10 > 0) {
            throw new Exception("Invalid duration (- must be at the beginning)");
        }
        String string2 = string.substring(n10 + 1);
        if (string2.charAt(0) != 'P') {
            throw new Exception("Invalid duration (P must be at the beginning)");
        }
        if ((string2 = string2.substring(1)).length() == 0) {
            throw new Exception("Invalid duration (nothing specified)");
        }
        n10 = string2.indexOf(84);
        String string3 = "";
        if (n10 > 0) {
            string3 = string2.substring(n10 + 1);
            if (string3.equals("")) {
                throw new Exception("Invalid duration (T with no time)");
            }
            string2 = string2.substring(0, n10);
        } else if (n10 == 0) {
            string3 = string2.substring(1);
            string2 = "";
        }
        if (!string2.equals("")) {
            this.validateDateFormat(string2);
            n3 = string2.indexOf(89);
            n2 = string2.indexOf(77);
            n = string2.indexOf(68);
            if (n3 != -1 && n2 != -1 && n3 > n2) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n3 != -1 && n != -1 && n3 > n) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n != -1 && n2 != -1 && n2 > n) {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (n3 >= 0) {
                n4 = new Integer(string2.substring(0, n3));
            }
            if (n2 >= 0) {
                n5 = new Integer(string2.substring(n3 + 1, n2));
            }
            if (n >= 0) {
                n6 = n2 >= 0 ? new Integer(string2.substring(n2 + 1, n)) : (n3 >= 0 ? new Integer(string2.substring(n3 + 1, n)).intValue() : new Integer(string2.substring(0, n)).intValue());
            }
        }
        if (!string3.equals("")) {
            this.validateHourFormat(string3);
            n3 = string3.indexOf(72);
            n2 = string3.indexOf(77);
            n = string3.indexOf(83);
            if (n3 != -1 && n2 != -1 && n3 > n2) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n3 != -1 && n != -1 && n3 > n) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n != -1 && n2 != -1 && n2 > n) {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (n3 >= 0) {
                n7 = new Integer(string3.substring(0, n3));
            }
            if (n2 >= 0) {
                n8 = new Integer(string3.substring(n3 + 1, n2));
            }
            if (n >= 0) {
                if (string3.length() != n + 1) {
                    throw new Exception("Invalid duration (Time part not properly specified)");
                }
                string3 = n2 >= 0 ? string3.substring(n2 + 1, string3.length() - 1) : (n3 >= 0 ? string3.substring(n3 + 1, string3.length() - 1) : string3.substring(0, string3.length() - 1));
                if (string3.indexOf(46) == string3.length() - 1) {
                    throw new Exception("Invalid duration (Time part not properly specified)");
                }
                n9 = new Double(string3).intValue();
            }
        }
        return n9 + n8 * 60 + n7 * 3600 + n6 * 86400 + n5 * 2592000 + n4 * 31536000;
    }

    private void validateDateFormat(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            if (!Character.isDigit(string.charAt(n4)) && string.charAt(n4) != 'Y' && string.charAt(n4) != 'M' && string.charAt(n4) != 'D') {
                throw new Exception("Invalid duration (Date part not properly specified)");
            }
            if (string.charAt(n4) == 'Y') {
                ++n;
            }
            if (string.charAt(n4) == 'M') {
                ++n2;
            }
            if (string.charAt(n4) == 'D') {
                ++n3;
            }
            ++n4;
        }
        if (n > 1 || n2 > 1 || n3 > 1) {
            throw new Exception("Invalid duration (Date part not properly specified)");
        }
    }

    private void validateHourFormat(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            if (!Character.isDigit(string.charAt(n4)) && string.charAt(n4) != 'H' && string.charAt(n4) != 'M' && string.charAt(n4) != 'S' && string.charAt(n4) != '.') {
                throw new Exception("Invalid duration (Time part not properly specified)");
            }
            if (string.charAt(n4) == 'H') {
                ++n3;
            }
            if (string.charAt(n4) == 'M') {
                ++n;
            }
            if (string.charAt(n4) == 'S') {
                ++n2;
            }
            ++n4;
        }
        if (n3 > 1 || n > 1 || n2 > 1) {
            throw new Exception("Invalid duration (Time part not properly specified)");
        }
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }
}

