use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

## want to *not* try to build Archive::Zip or Compress::Zlib on a
## windows system, this will weed those two out
my @list;
opendir D, '.';
foreach (readdir D) {
  next if (/^\./);
  next unless -d;
  next if (($^O eq 'MSWin32') or ($^O eq 'cygwin')) and (($_ =~ /Archive/) or ($_ =~ /Compress/));
  push @list, $_;
};
closedir D;
@list = sort @list;


## Carlo asked for a flag to turn off installation of all the CPAN
## stuff.  The approach here is to generate a Makefile with no-op
## targets.  This is a list of targets snarfed from a proper Makefile
## in this directory.
my @targets = qw(all pure_all subdirs config help linkext dynamic
		 static manifypods subdirs clean_subdirs clean
		 realclean_subdirs realclean purge metafile
		 metafile_addtomanifest distclean distcheck skipcheck
		 manifest veryclean dist tardist uutardist zipdist
		 shdist distdir disttest ci install install_perl
		 install_site install_vendor pure_install doc_install
		 pure__install doc__install pure_perl_install
		 pure_site_install pure_vendor_install
		 doc_perl_install doc_site_install doc_vendor_install
		 uninstall uninstall_from_perldirs
		 uninstall_from_sitedirs uninstall_from_vendordirs
		 testdb test test_dynamic testdb_dynamic test_
		 test_static testdb_static ppd pm_to_blib install);


if ($ENV{SKIP_ALL_CPAN_MODULES}) {
  open M, ">Makefile";
  print M "$_:\t\n" foreach (@targets);
  close M;
} else {
  WriteMakefile('NAME'    => 'HoraeBundle',
		'VERSION' => '2004.06.28',
		'DIR'     => \@list,
	       );
};
