/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	control.c

	control frontends to the functions located in runxanim.c

*/

#include "header.h"


void play_event(xcontrol *control)
{
	FILE *file = _NULL;

	char *tempname = _NULL;
	char *shortname = _NULL;
	char *savename = _NULL;
	char playname[50];
	
	raise_window(control->main->window);

	tempname = strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(control->main->combo)->entry)));
		
	if (file = fopen(tempname, "rb")) {
		
		fclose(file);
		control->movie->name = tempname;
		savename = dalloc(savename, strlen(tempname));
		sprintf(savename, "%s\0", tempname);

		shortname = file_only(control->movie->name);
		sprintf(playname, "  Playing %s...\0", shortname);
		control->play->playset = NOOP;
		
		if (val_xanim_file(control)) {
				
			control->main->history_list = g_list_first(save_history(control->main->history_list,
				(gpointer) savename));

			gtk_combo_set_popdown_strings(GTK_COMBO(control->main->combo),control->main->history_list);
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(control->main->combo)->entry), tempname);

			gtk_statusbar_push(GTK_STATUSBAR(control->main->statbar), control->main->context_id, playname);
			
			runxanim(control);
		} 

		dfree(savename);
		dfree(shortname);
		
	} 
	
	return;
}

void stopxanim (GtkWidget *widget, xcontrol *control) 
{
	control->play->playset = NOOP;
	setxanim(control, "q");
	return;
}

void set_volume (GtkWidget *widget, xcontrol *control) 
{
	I8 oldvolume;
	
	oldvolume = control->movie->volume;
	control->movie->volume = (I8) ((GtkAdjustment *) control->main->voladjust )->value;

	if (oldvolume != control->movie->volume && control->play->playing == PLAYING) {
				
		if (control->movie->volume > oldvolume) {
			for (; oldvolume < control->movie->volume; oldvolume++) {
				setxanim(control, "3");
			}
		} else {
			for (; oldvolume > control->movie->volume; oldvolume--) {
				setxanim(control, "2");
			}
		}	
	}

	return;
}

void pause_frame (GtkWidget *widget, xcontrol *control) 
{
	setxanim(control, " ");
	return;
}

void frame_up (GtkWidget *widget, xcontrol *control) 
{
	setxanim(control, "/");
	return;
}

void frame_back (GtkWidget *widget, xcontrol *control) 
{
	setxanim(control, "m");
	return;
}

void mute_sound (GtkWidget *widget, xcontrol *control) 
{
	setxanim(control, "s");
	return;
}

void set_play (GtkWidget *widget, xcontrol *control) 
{
	stopxanim(_NULL, control);
	control->play->playset = AUTOPLAY; 
	return;
}
