
import java.sql.*;


/**
 * test ResultSetMetaData.isReadonly, ResultSetMetaData.isNullable,
 *      ResultSetMetaData.isAutoIncrement
 *
 */
public class t0049
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;





      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0049b");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0049b', because it does")))
         {
            throw e;
         }
      }
      try
      {
         stmt.executeUpdate("drop table t0049a");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0049a', because it does")))
         {
            throw e;
         }
      }


      String query = 
         "create table t0049a(                    " +
         "  a integer identity(1,1) primary key,  " +
         "  b char    not null)";
         
      count = stmt.executeUpdate(query);
      System.out.println("Creating table affected " + count + " rows");


      query = 
         "create table t0049b(                    " +
         "  a integer not null,                   " +
         "  c char    not null,                   " +
         "  foreign key (a) references t0049a(a)) ";
      count = stmt.executeUpdate(query);
      System.out.println("Creating table affected " + count + " rows");


      query = "insert into t0049b (a, c) values (?, ?)";
      java.sql.PreparedStatement pstmt = cx.prepareStatement(query);

      try
      {
         pstmt.setInt(1, 1);
         pstmt.setString(2, "a");
         count = pstmt.executeUpdate();
      }
      catch(SQLException e)
      {
         if (! (e.getMessage().startsWith("INSERT statement conflicted")))
         {
            throw e;
         }
      }

      query = "insert into t0049a (b) values ('a')";
      count = stmt.executeUpdate(query);
      System.out.println("insert affected " + count + " rows");

      pstmt.setInt(1, 1);
      pstmt.setString(2, "a");
      count = pstmt.executeUpdate();


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0049.\n");
      System.exit(passed ? 0 : 1);
   }
}

