
import java.sql.*;


/**
 * Test blob support
 *
 */
public class t0021
{
   // return -1 if a1<a2, 0 if a1==a2, 1 if a1>a2
   static int compareBytes(byte a1[], byte a2[])
   {
      int   result;

      if (a1==a2)
      {
         result = 0;
      }
      else if (a1==null && a2!=null)
      {
         result = -1;
      }
      else if (a1!=null && a2==null)
      {
         result = 1;
      }
      else 
      {
         int  length = (a1.length<a2.length ? a1.length : a2.length);
         int  i; 

         for(i=0; i<length && a1[i]==a2[i]; i++)
         {
            // nop 
         }
         if (i==length)
         {
            if (a1.length==a2.length)
            {
               result = 0;
            }
            else if (a1.length<a2.length)
            {
               result = -1;
            }
            else 
            {
               result = 1;
            }
         }
         else
         {
            result = ((a1[i]&0xff)>(a2[i]&0xff) ? 1 : -1);
         }
      }
      return result;
   }


   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException
   {
      byte    smallarray[] =
      {
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10
      };
      
      byte    array1[] = 
      {
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
         0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08
      };
            String bigtext1 = 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "";


      System.out.println("Test blob support in prepared statements");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      boolean     passed   = true;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs;


      try
      {
         stmt.executeUpdate("drop table t0021");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0021', because it does")))
         {
            throw e;
         }
      }

      String sql =
         "create table t0021 (                       " +
         " mybinary         binary(16) not null ,    " + 
         " myimage          image not null,          " +       
         " mynullimage      image null,              " +
         " mytext           text not null,           " +
         " mynulltext       text null)               ";

      count = stmt.executeUpdate(sql);


      // Insert a row without nulls via a Statement
      sql =
         "insert into t0021(     " +
         " mybinary,             " + 
         " myimage,              " + 
         " mynullimage,          " +
         " mytext,               " +
         " mynulltext            " +
         ")                      " +
         "values(?, ?, ?, ?, ?)  ";
      PreparedStatement  insert = cx.prepareStatement(sql);

      insert.setBytes(1, smallarray);
      insert.setBytes(2, array1);
      insert.setBytes(3, array1);
      insert.setString(4, "abcd" /* bigtext1 */);
      insert.setString(5, "defg" /* bigtext1 */);
     
      count = insert.executeUpdate();
       
       sql = "select * from t0021";
       rs = stmt.executeQuery(sql);
       System.out.println("Executed query");
       if (!rs.next())
       {
          passed = false;
       }
       else
       {
          int      i;
          byte[]   a1 = rs.getBytes("myimage");
          byte[]   a2 = rs.getBytes("mynullimage");

          passed = passed && (compareBytes(a1, array1)==0);
          passed = passed && (compareBytes(a2, array1)==0);
       }
              
       System.out.println("\n" + (passed ? "Passed" : "Failed") 
                          + " t0021.\n");
       System.exit(passed ? 0 : 1);
   }
}

