//
// Copyright 1999 Craig Spannring
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All advertising materials mentioning features or use of this software
//    must display the following acknowledgement:
//      This product includes software developed by Craig Spannring
// 4. The name of Craig Spannring may not be used to endorse or promote
//    products derived from this software without specific prior
//    written permission.
//
// THIS SOFTWARE IS PROVIDED BY CRAIG SPANNRING ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL CRAIG SPANNRING BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//


package com.internetcds.jdbc.tds;


import java.sql.*;
import java.math.BigDecimal;
import java.util.Vector;
// import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Calendar;



public class ResultSet_2_0 
   extends com.internetcds.jdbc.tds.ResultSet_base
   implements java.sql.ResultSet
{
   public static final String cvsVersion = "$Id: ResultSet_2_0.java,v 1.3 2000/07/17 04:41:05 cts Exp $";
   

   public ResultSet_2_0(Tds                                tds_, 
                        com.internetcds.jdbc.tds.Statement stmt_, 
                        Columns                            columns_)
   {
      super(tds_, stmt_, columns_);
   }

   
   //---------------------------------------------------------------------
   // Getter's and Setter's
   //---------------------------------------------------------------------
   
   /**
    * JDBC 2.0
    *
    * <p>Gets the value of a column in the current row as a java.io.Reader.
    * @param columnIndex the first column is 1, the second is 2, ...
    */
   public java.io.Reader getCharacterStream(int columnIndex) throws SQLException
   {
       String val = getString(columnIndex);
       if (val == null)
           return null;
       
       return new java.io.StringReader(val);
   }
   

    /**
     * JDBC 2.0
     *
     * <p>Gets the value of a column in the current row as a java.io.Reader.
     * @param columnName the name of the column
     * @return the value in the specified column as a <code>java.io.Reader</code>
     */
   public java.io.Reader getCharacterStream(String columnName) throws SQLException
   {
      return getCharacterStream(findColumn(columnName));
   }
   
   
   /**
    * JDBC 2.0
    *
    * Gets the value of a column in the current row as a java.math.BigDecimal 
    * object with full precision.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @return the column value (full precision); if the value is SQL NULL, 
    * the result is null
    * @exception SQLException if a database access error occurs
    */
   public BigDecimal getBigDecimal(int columnIndex) throws SQLException
   {
      NotImplemented();
      return null;
   }
   
   
   /**
    * JDBC 2.0
    *
    * Gets the value of a column in the current row as a java.math.BigDecimal 
    * object with full precision.
    * @param columnName the column name
    * @return the column value (full precision); if the value is SQL NULL, 
    * the result is null
    * @exception SQLException if a database access error occurs
    *
    */
   public BigDecimal getBigDecimal(String columnName) throws SQLException
   {
      NotImplemented();
      return null;
   }
   
   
   //---------------------------------------------------------------------
   // Traversal/Positioning
   //---------------------------------------------------------------------
   
   /**
    * JDBC 2.0
    *
    * <p>Indicates whether the cursor is before the first row in the result 
    * set.   
    *
    * @return true if the cursor is before the first row, 
    *         false otherwise. Returns
    * false when the result set contains no rows.
    * @exception SQLException if a database access error occurs
    */
   public boolean isBeforeFirst() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Indicates whether the cursor is after the last row in the result 
    * set.   
    *
    * @return true if the cursor is  after the last row, false otherwise.  Returns
    * false when the result set contains no rows.
    * @exception SQLException if a database access error occurs
    */
   public boolean isAfterLast() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Indicates whether the cursor is on the first row of the result set.   
    *
    * @return true if the cursor is on the first row, false otherwise.   
    * @exception SQLException if a database access error occurs
    */
   public boolean isFirst() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Indicates whether the cursor is on the last row of the result set.   
    * Note: Calling the method <code>isLast</code> may be expensive
    * because the JDBC driver
    * might need to fetch ahead one row in order to determine 
    * whether the current row is the last row in the result set.
    *
    * @return true if the cursor is on the last row, false otherwise. 
    * @exception SQLException if a database access error occurs
    */
   public boolean isLast() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Moves the cursor to the front of the result set, just before the
    * first row. Has no effect if the result set contains no rows.
    *
    * @exception SQLException if a database access error occurs or the 
    * result set type is TYPE_FORWARD_ONLY
    */
   public void beforeFirst() throws SQLException
   {
      NotImplemented();
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Moves the cursor to the end of the result set, just after the last
    * row.  Has no effect if the result set contains no rows.
    *
    * @exception SQLException if a database access error occurs or the 
    * result set type is TYPE_FORWARD_ONLY 
    */
   public void afterLast() throws SQLException
   {
      NotImplemented();
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Moves the cursor to the first row in the result set.  
    *
    * @return true if the cursor is on a valid row; false if
    *         there are no rows in the result set
    * @exception SQLException if a database access error occurs or the 
    * result set type is TYPE_FORWARD_ONLY
    */
   public boolean first() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Moves the cursor to the last row in the result set.  
    *
    * @return true if the cursor is on a valid row;
    * false if there are no rows in the result set
    * @exception SQLException if a database access error occurs or the
    * result set type is TYPE_FORWARD_ONLY.
    */
   public boolean last() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * <p>Retrieves the current row number.  The first row is number 1, the
     * second number 2, and so on.  
     *
     * @return the current row number; 0 if there is no current row
     * @exception SQLException if a database access error occurs
     */
   public int getRow() throws SQLException
   {
      NotImplemented();
      return 0;
   }


   /**
     * JDBC 2.0
     *
     * <p>Moves the cursor to the given row number in the result set.
     *
     * <p>If the row number is positive, the cursor moves to 
     * the given row number with respect to the
     * beginning of the result set.  The first row is row 1, the second
     * is row 2, and so on. 
     *
     * <p>If the given row number is negative, the cursor moves to
     * an absolute row position with respect to
     * the end of the result set.  For example, calling
     * <code>absolute(-1)</code> positions the 
     * cursor on the last row, <code>absolute(-2)</code> indicates the next-to-last
     * row, and so on.
     *
     * <p>An attempt to position the cursor beyond the first/last row in
     * the result set leaves the cursor before/after the first/last
     * row, respectively.
     *
     * <p>Note: Calling <code>absolute(1)</code> is the same
     * as calling <code>first()</code>.
     * Calling <code>absolute(-1)</code> is the same as calling <code>last()</code>.
     *
     * @return true if the cursor is on the result set; false otherwise
     * @exception SQLException if a database access error occurs or 
     * row is 0, or result set type is TYPE_FORWARD_ONLY.
     */
   public boolean absolute( int row ) throws SQLException
   {
      NotImplemented();
      return false;
   }


   /**
     * JDBC 2.0
     *
     * <p>Moves the cursor a relative number of rows, either positive or negative.
     * Attempting to move beyond the first/last row in the
     * result set positions the cursor before/after the
     * the first/last row. Calling <code>relative(0)</code> is valid, but does
     * not change the cursor position.
     *
     * <p>Note: Calling <code>relative(1)</code>
     * is different from calling <code>next()</code>
     * because is makes sense to call <code>next()</code> when there is no current row,
     * for example, when the cursor is positioned before the first row
     * or after the last row of the result set.
     *
     * @return true if the cursor is on a row; false otherwise
     * @exception SQLException if a database access error occurs, there
     * is no current row, or the result set type is TYPE_FORWARD_ONLY
     */
   public boolean relative( int rows ) throws SQLException
   {
      NotImplemented();
      return false;
   }


   /**
     * JDBC 2.0
     *
     * <p>Moves the cursor to the previous row in the result set.  
     *
     * <p>Note: <code>previous()</code> is not the same as
     * <code>relative(-1)</code> because it
     * makes sense to call</code>previous()</code> when there is no current row.
     *
     * @return true if the cursor is on a valid row; false if it is off the result set
     * @exception SQLException if a database access error occurs or the
     * result set type is TYPE_FORWARD_ONLY
     */
   public boolean previous() throws SQLException
   {
      NotImplemented();
      return false;
   }


   //---------------------------------------------------------------------
   // Properties
   //---------------------------------------------------------------------

    /**
     * JDBC 2.0
     *
     * The rows in a result set will be processed in a forward direction;
     * first-to-last.
     */
   int FETCH_FORWARD = 1000;

   /**
     * JDBC 2.0
     *
     * The rows in a result set will be processed in a reverse direction;
     * last-to-first.
     */
   int FETCH_REVERSE = 1001;

   /**
     * JDBC 2.0
     * 
     * The order in which rows in a result set will be processed is unknown.
     */
   int FETCH_UNKNOWN = 1002;

   /**
     * JDBC 2.0
     *
     * Gives a hint as to the direction in which the rows in this result set
     * will be processed.  The initial value is determined by the statement
     * that produced the result set.  The fetch direction may be changed
     * at any time.
     *
     * @exception SQLException if a database access error occurs or
     * the result set type is TYPE_FORWARD_ONLY and the fetch direction is not 
     * FETCH_FORWARD.
     */
   public void setFetchDirection(int direction) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Returns the fetch direction for this result set.
     *
     * @return the current fetch direction for this result set
     * @exception SQLException if a database access error occurs
     */
   public int getFetchDirection() throws SQLException
   {
      NotImplemented();
      return 0;
   }


   /**
     * JDBC 2.0
     *
     * Gives the JDBC driver a hint as to the number of rows that should 
     * be fetched from the database when more rows are needed for this result
     * set.  If the fetch size specified is zero, the JDBC driver 
     * ignores the value and is free to make its own best guess as to what
     * the fetch size should be.  The default value is set by the statement 
     * that created the result set.  The fetch size may be changed at any 
     * time.
     *
     * @param rows the number of rows to fetch
     * @exception SQLException if a database access error occurs or the
     * condition 0 <= rows <= this.getMaxRows() is not satisfied.
     */
   public void setFetchSize(int rows) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Returns the fetch size for this result set.
     *
     * @return the current fetch size for this result set
     * @exception SQLException if a database access error occurs
     */
   public int getFetchSize() throws SQLException
   {
      NotImplemented();
      return 0;
   }


   /**
     * JDBC 2.0
     * The type for a <code>ResultSet</code> object whose cursor may
     * move only forward.
     */
   int TYPE_FORWARD_ONLY = 1003;

   /**
     * JDBC 2.0
     * The type for a <code>ResultSet</code> object that is scrollable
     * but generally not sensitive to changes made by others.
     * 
     */
   int TYPE_SCROLL_INSENSITIVE = 1004;
   
   /**
     * JDBC 2.0
     * The type for a <code>ResultSet</code> object that is scrollable
     * and generally sensitive to changes made by others.
     */
   int TYPE_SCROLL_SENSITIVE = 1005;

   /**
     * JDBC 2.0
     *
     * Returns the type of this result set.  The type is determined by
     * the statement that created the result set.
     *
     * @return TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, or
     * TYPE_SCROLL_SENSITIVE
     * @exception SQLException if a database access error occurs
     */
   public int getType() throws SQLException
   {
      NotImplemented();
      return 0;
   }


   /**
     * JDBC 2.0
     * The concurrency mode for a <code>ResultSet</code> object
     * that may NOT be updated.
     *  
     */
   int CONCUR_READ_ONLY = 1007;

   /**
     * JDBC 2.0
     * The concurrency mode for a <code>ResultSet</code> object
     * that may be updated.
     * 
     */
   int CONCUR_UPDATABLE = 1008;
   
   /**
    * JDBC 2.0
    *
    * Returns the concurrency mode of this result set.  The concurrency
    * used is determined by the statement that created the result set.
    *
    * @return the concurrency type, CONCUR_READ_ONLY or CONCUR_UPDATABLE
    * @exception SQLException if a database access error occurs
    */
   public int getConcurrency() throws SQLException
   {
      NotImplemented();
      return 0;
   }
   
   
   //---------------------------------------------------------------------
   // Updates
   //---------------------------------------------------------------------
   
   /**
    * JDBC 2.0
    *
    * Indicates whether the current row has been updated.  The value returned 
    * depends on whether or not the result set can detect updates.
    *
    * @return true if the row has been visibly updated by the owner or
    * another, and updates are detected
    * @exception SQLException if a database access error occurs
    * 
    * @see DatabaseMetaData#updatesAreDetected
    */
   public boolean rowUpdated() throws SQLException
   {
      NotImplemented();
      return false;
   }
   
   
   /**
    * JDBC 2.0
    *
    * Indicates whether the current row has had an insertion.  The value returned 
    * depends on whether or not the result set can detect visible inserts.
    *
    * @return true if a row has had an insertion and insertions are detected
    * @exception SQLException if a database access error occurs
    * 
    * @see DatabaseMetaData#insertsAreDetected
    */
   public boolean rowInserted() throws SQLException
   {
      NotImplemented();
      return false;
   }

   
   /**
    * JDBC 2.0
    *
    * Indicates whether a row has been deleted.  A deleted row may leave
    * a visible "hole" in a result set.  This method can be used to
    * detect holes in a result set.  The value returned depends on whether 
    * or not the result set can detect deletions.
    *
    * @return true if a row was deleted and deletions are detected
    * @exception SQLException if a database access error occurs
    * 
    * @see DatabaseMetaData#deletesAreDetected
    */
   public boolean rowDeleted() throws SQLException
   {
      NotImplemented();
      return false;
   }


   /**
    * JDBC 2.0
    * 
    * Give a nullable column a null value.
    * 
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @exception SQLException if a database access error occurs
    */
   public void updateNull(int columnIndex) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    * 
    * Updates a column with a boolean value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateBoolean(int columnIndex, boolean x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *   
    * Updates a column with a byte value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateByte(int columnIndex, byte x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *   
    * Updates a column with a short value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateShort(int columnIndex, short x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *   
    * Updates a column with an integer value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateInt(int columnIndex, int x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *   
    * Updates a column with a long value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateLong(int columnIndex, long x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a float value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateFloat(int columnIndex, float x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a Double value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateDouble(int columnIndex, double x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a BigDecimal value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a String value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateString(int columnIndex, String x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a byte array value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateBytes(int columnIndex, byte x[]) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a Date value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateDate(int columnIndex, java.sql.Date x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a Time value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateTime(int columnIndex, java.sql.Time x) throws SQLException
   {
      NotImplemented();
   }

   /**
    * JDBC 2.0
    *  
    * Updates a column with a Timestamp value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateTimestamp(int columnIndex, java.sql.Timestamp x) throws SQLException
   {
      NotImplemented();
   }


   /** 
    * JDBC 2.0
    *  
    * Updates a column with an ascii stream value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @param length the length of the stream
    * @exception SQLException if a database access error occurs
    */
   public void updateAsciiStream(int columnIndex, 
                                 java.io.InputStream x, 
                                 int length) throws SQLException
   {
      NotImplemented();
   }


   /** 
    * JDBC 2.0
    *  
    * Updates a column with a binary stream value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value     
    * @param length the length of the stream
    * @exception SQLException if a database access error occurs
    */
   public void updateBinaryStream(int columnIndex, 
                                  java.io.InputStream x,
                                  int length) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a character stream value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @param length the length of the stream
    * @exception SQLException if a database access error occurs
    */
   public void updateCharacterStream(int columnIndex,
                                     java.io.Reader x,
                                     int length) throws SQLException
   {
      NotImplemented();
   }

   /**
    * JDBC 2.0
    *  
    * Updates a column with an Object value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
    *  this is the number of digits after the decimal.  For all other
    *  types this value will be ignored.
    * @exception SQLException if a database access error occurs
    */
   public void updateObject(int columnIndex, Object x, int scale) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with an Object value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnIndex the first column is 1, the second is 2, ...
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateObject(int columnIndex, Object x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a null value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @exception SQLException if a database access error occurs
    */
   public void updateNull(String columnName) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a boolean value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateBoolean(String columnName, boolean x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a byte value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateByte(String columnName, byte x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a short value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateShort(String columnName, short x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with an integer value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateInt(String columnName, int x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * JDBC 2.0
    *  
    * Updates a column with a long value.
    *
    * The <code>updateXXX</code> methods are used to update column values in the
    * current row, or the insert row.  The <code>updateXXX</code> methods do not 
    * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
    * methods are called to update the database.
    *
    * @param columnName the name of the column
    * @param x the new column value
    * @exception SQLException if a database access error occurs
    */
   public void updateLong(String columnName, long x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a float value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateFloat(String columnName, float x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a double value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateDouble(String columnName, double x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a BigDecimal value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a String value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateString(String columnName, String x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a byte array value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateBytes(String columnName, byte x[]) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a Date value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateDate(String columnName, java.sql.Date x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a Time value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateTime(String columnName, java.sql.Time x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a Timestamp value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateTimestamp(String columnName, java.sql.Timestamp x)      throws SQLException
   {
      NotImplemented();
   }


   /** 
     * JDBC 2.0
     *  
     * Updates a column with an ascii stream value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception SQLException if a database access error occurs
     */
   public void updateAsciiStream(String columnName, 
                                 java.io.InputStream x, 
                                 int length) throws SQLException
   {
      NotImplemented();
   }


   /** 
     * JDBC 2.0
     *  
     * Updates a column with a binary stream value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception SQLException if a database access error occurs
     */
   public void updateBinaryStream(String columnName, 
                                  java.io.InputStream x,
                                  int length) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with a character stream value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception SQLException if a database access error occurs
     */
   public void updateCharacterStream(String columnName,
                                     java.io.Reader reader,
                                     int length) throws SQLException 
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with an Object value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
     *  this is the number of digits after the decimal.  For all other
     *  types this value will be ignored.
     * @exception SQLException if a database access error occurs
     */
   public void updateObject(String columnName, Object x, int scale)      throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *  
     * Updates a column with an Object value.
     *
     * The <code>updateXXX</code> methods are used to update column values in the
     * current row, or the insert row.  The <code>updateXXX</code> methods do not 
     * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception SQLException if a database access error occurs
     */
   public void updateObject(String columnName, Object x) throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Inserts the contents of the insert row into the result set and
     * the database.  Must be on the insert row when this method is called.
     *
     * @exception SQLException if a database access error occurs,
     * if called when not on the insert row, or if not all of non-nullable columns in
     * the insert row have been given a value
     */
   public void insertRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Updates the underlying database with the new contents of the
     * current row.  Cannot be called when on the insert row.
     *
     * @exception SQLException if a database access error occurs or
     * if called when on the insert row
     */
   public void updateRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Deletes the current row from the result set and the underlying
     * database.  Cannot be called when on the insert row.
     *
     * @exception SQLException if a database access error occurs or if
     * called when on the insert row.
     */
   public void deleteRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Refreshes the current row with its most recent value in 
     * the database.  Cannot be called when on the insert row.
     *
     * The <code>refreshRow</code> method provides a way for an application to 
     * explicitly tell the JDBC driver to refetch a row(s) from the
     * database.  An application may want to call <code>refreshRow</code> when 
     * caching or prefetching is being done by the JDBC driver to
     * fetch the latest value of a row from the database.  The JDBC driver 
     * may actually refresh multiple rows at once if the fetch size is 
     * greater than one.
     * 
     * All values are refetched subject to the transaction isolation 
     * level and cursor sensitivity.  If <code>refreshRow</code> is called after
     * calling <code>updateXXX</code>, but before calling <code>updateRow</code>, then the
     * updates made to the row are lost.  Calling the method <code>refreshRow</code> frequently
     * will likely slow performance.
     *
     * @exception SQLException if a database access error occurs or if
     * called when on the insert row
     */
   public void refreshRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Cancels the updates made to a row.
     * This method may be called after calling an
     * <code>updateXXX</code> method(s) and before calling <code>updateRow</code> to rollback 
     * the updates made to a row.  If no updates have been made or 
     * <code>updateRow</code> has already been called, then this method has no 
     * effect.
     *
     * @exception SQLException if a database access error occurs or if
     * called when on the insert row
     *
     */
   public void cancelRowUpdates() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Moves the cursor to the insert row.  The current cursor position is 
     * remembered while the cursor is positioned on the insert row.
     *
     * The insert row is a special row associated with an updatable
     * result set.  It is essentially a buffer where a new row may
     * be constructed by calling the <code>updateXXX</code> methods prior to 
     * inserting the row into the result set.  
     *
     * Only the <code>updateXXX</code>, <code>getXXX</code>,
     * and <code>insertRow</code> methods may be 
     * called when the cursor is on the insert row.  All of the columns in 
     * a result set must be given a value each time this method is
     * called before calling <code>insertRow</code>.  
     * The method <code>updateXXX</code> must be called before a
     * <code>getXXX</code> method can be called on a column value.
     *
     * @exception SQLException if a database access error occurs
     * or the result set is not updatable
     */
   public void moveToInsertRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Moves the cursor to the remembered cursor position, usually the
     * current row.  This method has no effect if the cursor is not on the insert 
     * row. 
     *
     * @exception SQLException if a database access error occurs
     * or the result set is not updatable
     */
   public void moveToCurrentRow() throws SQLException
   {
      NotImplemented();
   }


   /**
     * JDBC 2.0
     *
     * Returns the Statement that produced this <code>ResultSet</code> object.
     * If the result set was generated some other way, such as by a
     * <code>DatabaseMetaData</code> method, this method returns <code>null</code>.
     *
     * @return the Statment that produced the result set or
     * null if the result set was produced some other way
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Statement getStatement() throws SQLException
   {
      return stmt;
   }


   /**
     * JDBC 2.0
     *
     * Returns the value of a column in the current row as a Java object.  
     * This method uses the given <code>Map</code> object
     * for the custom mapping of the
     * SQL structured or distinct type that is being retrieved.
     *
     * @param i the first column is 1, the second is 2, ...
     * @param map the mapping from SQL type names to Java classes
     * @return an object representing the SQL value
     */
   public Object getObject(int i, java.util.Map map) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets a REF(&lt;structured-type&gt;) column value from the current row.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return a <code>Ref</code> object representing an SQL REF value
     */
   public Ref getRef(int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets a BLOB value in the current row of this <code>ResultSet</code> object.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return a <code>Blob</code> object representing the SQL BLOB value in
     *         the specified column
     */
   public Blob getBlob(int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets a CLOB value in the current row of this <code>ResultSet</code> object.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return a <code>Clob</code> object representing the SQL CLOB value in
     *         the specified column
     */
   public Clob getClob(int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets an SQL ARRAY value from the current row of this <code>ResultSet</code> object.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return an <code>Array</code> object representing the SQL ARRAY value in
     *         the specified column
     */
   public Array getArray(int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Returns the value in the specified column as a Java object.  
     * This method uses the specified <code>Map</code> object for
     * custom mapping if appropriate.
     *
     * @param colName the name of the column from which to retrieve the value
     * @param map the mapping from SQL type names to Java classes
     * @return an object representing the SQL value in the specified column
     */
   public Object getObject(String colName, java.util.Map map) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets a REF(&lt;structured-type&gt;) column value from the current row.
     *
     * @param colName the column name
     * @return a <code>Ref</code> object representing the SQL REF value in
     *         the specified column
     */
   public Ref getRef(String colName) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * JDBC 2.0
     *
     * Gets a BLOB value in the current row of this <code>ResultSet</code> object.
     *
     * @param colName the name of the column from which to retrieve the value
     * @return a <code>Blob</code> object representing the SQL BLOB value in
     *         the specified column
     */
   public Blob getBlob(String colName) throws SQLException
   {
      NotImplemented();
      return null;
   }

   
   /**
    * JDBC 2.0
    *
    * Gets a CLOB value in the current row of this <code>ResultSet</code> object.
    *
    * @param colName the name of the column from which to retrieve the value
    * @return a <code>Clob</code> object representing the SQL CLOB value in
    *         the specified column
    */
   public Clob getClob(String colName) throws SQLException
   {
      NotImplemented();
      return null;
   }
   

   /**
     * JDBC 2.0
     *
     * Gets an SQL ARRAY value in the current row of this <code>ResultSet</code> object.
     *
     * @param colName the name of the column from which to retrieve the value
     * @return an <code>Array</code> object representing the SQL ARRAY value in
     *         the specified column
     */
   public Array getArray(String colName) throws SQLException
   {
      NotImplemented();
      return null;
   }



   /**
     * Gets the value of a column in the current row as a java.sql.Timestamp 
     * object. This method uses the given calendar to construct an 
     * appropriate millisecond value for the Timestamp if the underlying 
     * database does not store timezone information.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param cal the calendar to use in constructing the timestamp
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Timestamp getTimestamp(int columnIndex, Calendar cal) 
      throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * Gets the value of a column in the current row as a
     * java.sql.Timestamp object. This method uses the given calendar
     * to construct an appropriate millisecond value for the Timestamp
     * if the underlying database does not store timezone information.  
     *
     * @param columnName the SQL name of the column
     * @param cal the calendar to use in constructing the timestamp
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Timestamp getTimestamp(String columnName, Calendar cal) 
      throws SQLException
   {
      NotImplemented();
      return null;
   }



   /**
     * JDBC 2.0
     *
     * Gets the value of a column in the current row as a
     * java.sql.Date object. This method uses the given calendar to
     * construct an appropriate millisecond value for the Date if the
     * underlying database does not store timezone information.  
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param cal the calendar to use in constructing the date
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * Gets the value of a column in the current row as a
     * java.sql.Date object. This method uses the given calendar to
     * construct an appropriate millisecond value for the Date, if the
     * underlying database does not store timezone information.  
     *
     * @param columnName the SQL name of the column from which to retrieve the value
     * @param cal the calendar to use in constructing the date
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Date getDate(String columnName, Calendar cal) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
     * Gets the value of a column in the current row as a
     * java.sql.Time object. This method uses the given calendar to
     * construct an appropriate millisecond value for the Time if the
     * underlying database does not store timezone information. 
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param cal the calendar to use in constructing the time
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception SQLException if a database access error occurs
     */
   public java.sql.Time getTime(int columnIndex, Calendar cal)
      throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
    * Gets the value of a column in the current row as a java.sql.Time 
    * object. This method uses the given calendar to construct an 
    * appropriate millisecond
    * value for the Time if the underlying database does not store
    * timezone information.
    *
    * @param columnName the SQL name of the column
    * @param cal the calendar to use in constructing the time
    * @return the column value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database access error occurs
    */
   public java.sql.Time getTime(String columnName, Calendar cal) 
      throws SQLException
   {
      NotImplemented();
      return null;
   }
}
