/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.ccil.cowan.tagsoup.ElementType;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.PYXScanner;
import org.ccil.cowan.tagsoup.PYXWriter;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CommandLine {
    static HashMap options = new HashMap();
    private static Parser myParser;

    public static void main(String[] stringArray) throws IOException, SAXException {
        Object object;
        HTMLSchema hTMLSchema = HTMLSchema.sharedSchema();
        int n = CommandLine.getopts(options, stringArray);
        if (CommandLine.hasOption(options, "--nocdata")) {
            ElementType elementType = hTMLSchema.getElementType("script");
            elementType.setFlags(0);
            object = hTMLSchema.getElementType("style");
            ((ElementType)object).setFlags(0);
        }
        if (stringArray.length == n) {
            CommandLine.process("", System.out);
        } else if (CommandLine.hasOption(options, "--files")) {
            for (int i = n; i < stringArray.length; ++i) {
                object = stringArray[i];
                int n2 = ((String)object).lastIndexOf(46);
                String string = n2 == -1 ? (String)object + ".xhtml" : (((String)object).endsWith(".xhtml") ? (String)object + "_" : ((String)object).substring(0, n2) + ".xhtml");
                System.err.println("src: " + (String)object + " dst: " + string);
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                CommandLine.process((String)object, fileOutputStream);
            }
        } else {
            for (int i = n; i < stringArray.length; ++i) {
                System.err.println("src: " + stringArray[i]);
                CommandLine.process(stringArray[i], System.out);
            }
        }
    }

    private static void process(String string, OutputStream outputStream) throws IOException, SAXException {
        Parser parser;
        if (CommandLine.hasOption(options, "--reuse")) {
            if (myParser == null) {
                myParser = new Parser();
            }
            parser = myParser;
        } else {
            parser = new Parser();
        }
        if (CommandLine.hasOption(options, "--nons")) {
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        if (CommandLine.hasOption(options, "--nobogons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
        }
        if (CommandLine.hasOption(options, "--any")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
        }
        if (CommandLine.hasOption(options, "--pyxin")) {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/scanner", new PYXScanner());
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        ContentHandler contentHandler = CommandLine.chooseContentHandler(outputStreamWriter);
        parser.setContentHandler(contentHandler);
        if (CommandLine.hasOption(options, "--lexical") && contentHandler instanceof LexicalHandler) {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        InputSource inputSource = new InputSource();
        if (string != "") {
            inputSource.setSystemId(string);
        } else {
            inputSource.setByteStream(System.in);
        }
        String string2 = (String)options.get("--encoding=");
        if (string2 != null) {
            inputSource.setEncoding(string2);
        }
        parser.parse(inputSource);
    }

    private static ContentHandler chooseContentHandler(Writer writer) {
        ContentHandler contentHandler;
        if (CommandLine.hasOption(options, "--pyx")) {
            contentHandler = new PYXWriter(writer);
        } else if (CommandLine.hasOption(options, "--html")) {
            XMLWriter xMLWriter = new XMLWriter(writer);
            xMLWriter.setHTMLMode(true);
            contentHandler = xMLWriter;
        } else {
            contentHandler = new XMLWriter(writer);
        }
        return contentHandler;
    }

    private static int getopts(HashMap hashMap, String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            String string2 = null;
            if (string.charAt(0) != '-') break;
            int n2 = string.indexOf(61);
            if (n2 != -1) {
                string2 = string.substring(n2 + 1, string.length());
                string = string.substring(0, n2 + 1);
            }
            if (hashMap.containsKey(string)) {
                if (string2 == null) {
                    hashMap.put(string, Boolean.TRUE);
                    continue;
                }
                hashMap.put(string, string2);
                continue;
            }
            System.err.print("Unknown option ");
            System.err.println(string);
            System.exit(1);
        }
        return n;
    }

    private static boolean hasOption(HashMap hashMap, String string) {
        if (Boolean.getBoolean(string)) {
            return true;
        }
        return hashMap.get(string) == Boolean.TRUE;
    }

    static {
        options.put("--nocdata", null);
        options.put("--files", null);
        options.put("--reuse", null);
        options.put("--nons", null);
        options.put("--nobogons", null);
        options.put("--any", null);
        options.put("--pyxin", null);
        options.put("--lexical", null);
        options.put("--pyx", null);
        options.put("--html", null);
        options.put("--encoding=", null);
        myParser = null;
    }
}

