/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIAV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgAddValue(const char * const name, const char * const data
		char * comment, int type, int trustlevel);

	Add a new value to the current key.

	Return: cfg error code

ob(ject): cfgAddValue
su(bsystem): inifile/3
sh(ort description): Append a new value to the current section
lo(ng description): Append a new value to the current section. The data of
 the value is already transformed into its ASCII representation.
re(lated to): cfgSetValue
fi(le): cfgiav.c
pr: \para{name} != NULL

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIAV.C 1.4 2000/03/31 09:08:47 ska Exp ska $";
#endif

int cfgAddValue(const char * const name, const char * const data
	, const char * const comment, int type, int trustlevel)
{	int rv;

	DBG_ENTER("cfgAddValue", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\", data=\"%s\", cmt=\"%s\", typ=%d, lvl=%d", name, data, comment, type, trustlevel) )

	if(!hasKey(usrini))			/* need a key */
		DBG_RETURN_I( CFG_ERR_KEY)
	if(!name)
		DBG_RETURN_I( CFG_ERR_ARG)

	if(FFsetpos(usrini.cfgi_fp, usrini.cfgi_pos))	/* reset section */
		DBG_RETURN_I( CFG_ERR_ACC)

	chkHeap
	/* open the temporary output file */
	if((rv = cfgi_wrOpen()) == CFG_ERR_NONE
	 && (rv = cfgi_wrSetCurKey()) == CFG_ERR_NONE
	 && ((rv = cfgi_nxtSec(usrini.cfgi_fp)) == CFG_ERR_NONE
	     || rv == CFG_ERR_KEY)
		/* copy everything preceeding the next section */
	 && (rv = cfgi_copyallto(aS(I(curpos)))) == CFG_ERR_NONE) {
	 	Fposcpy(aS(I(writePos)), aS(I(curpos)));
	 	I(writeOpen) = CFG_WSECTION;
		chkHeap
		rv = cfgCreateDataLineINI(name, cfgi_packData(data, comment, 0)
		 , type, trustlevel);
		chkHeap
	}

	DBG_RETURN_BI( cfgi_wrClose(rv))
}
