/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.FileLoader;
import dguitar.gui.DGuitar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class FileLoaderHandler
implements ActionListener {
    private DGuitar parent;
    private String msg;
    private String fileName;
    private ProgressMonitor progressMonitor;
    private FileLoader fileLoader;
    private PropertyResourceBundle lang;
    private Timer timer;
    public static final int EMPTY = 0;
    public static final int GUITAR_PRO = 1;
    public static final int MIDI = 2;
    private int fileType;
    private boolean evaluate;
    private long start;
    private long finish;

    public FileLoaderHandler(DGuitar dguitar, String aFileName, boolean Evaluate) {
        this.parent = dguitar;
        this.fileName = aFileName;
        this.setFileType(this.fileName);
        this.lang = DGuitar.lang;
        this.evaluate = Evaluate;
    }

    public void start() {
        if (this.parent.OpenedListContains(this.fileName)) {
            this.parent.showMessageAlreadyOpen(this.fileName);
        } else {
            DGuitar.LS.print(String.valueOf(this.lang.getString("Opening_file")) + " " + this.fileName);
            this.fileLoader = new FileLoader(this.fileName);
            this.progressMonitor = new ProgressMonitor(this.parent, this.lang.getString("Loading_FILE"), "", 0, this.fileLoader.getLengthOfTask());
            this.progressMonitor.setProgress(0);
            this.progressMonitor.setMillisToDecideToPopup(1000);
            this.timer = new Timer(1000, this);
            this.start = System.currentTimeMillis();
            this.fileLoader.loadFile();
            this.timer.start();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.progressMonitor.setProgress(this.fileLoader.getCurrent());
        String s = this.fileLoader.getMessage();
        if (s != null) {
            this.progressMonitor.setNote(s);
        }
        if (this.progressMonitor.isCanceled() || this.fileLoader.isDone()) {
            this.progressMonitor.close();
            this.fileLoader.stop();
            this.timer.stop();
            if (this.fileLoader.isDone()) {
                if (this.fileLoader.success) {
                    this.finishLoadAndDisplay(this.fileName, this.fileLoader.resp);
                } else {
                    this.msg = String.valueOf(DGuitar.lang.getString("File")) + "'" + this.fileName + "' ";
                    this.msg = String.valueOf(this.msg) + this.lang.getString("load_FAILED") + this.fileLoader.errorCode;
                    this.parent.showDialogOk(this.lang.getString("ERROR_FILE_NOT_LOADED"), this.msg);
                }
            } else {
                this.msg = String.valueOf(this.lang.getString("Loading_of")) + "'" + this.fileName + "' ";
                this.msg = String.valueOf(this.msg) + this.lang.getString("was_canceled_by_USER") + this.fileLoader.errorCode;
                this.parent.showDialogOk(this.lang.getString("Load_was_CANCELED"), this.msg);
            }
        }
    }

    private void finishLoadAndDisplay(String aFileName, byte[] bytes) {
        switch (this.fileType) {
            case 1: {
                this.parent.displayGP(aFileName, bytes);
                break;
            }
            case 2: {
                this.parent.displayMID(aFileName);
            }
        }
        if (this.evaluate) {
            this.finish = System.currentTimeMillis();
            String aux = String.valueOf(this.fileName) + " ";
            aux = String.valueOf(aux) + this.lang.getString("Complete_display_process_took:");
            aux = String.valueOf(aux) + (this.finish - this.start) / 1000L + " " + this.lang.getString("seconds");
            DGuitar.LS.log(aux);
        }
    }

    private void setFileType(String fileName) {
        if (DGuitar.gpFileFilter.accept(fileName)) {
            this.fileType = 1;
        } else if (DGuitar.midiFileFilter.accept(fileName)) {
            this.fileType = 2;
        }
    }
}

