/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend.constantpool;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPoolEntry;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.NameAndTypeCPInfo;

public class MethodRefCPInfo
extends ConstantPoolEntry {
    private String methodClassName;
    private String methodName;
    private String methodType;
    private int classIndex;
    private int nameAndTypeIndex;

    public MethodRefCPInfo() {
        super(10, 1);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.classIndex = dataInputStream.readUnsignedShort();
        this.nameAndTypeIndex = dataInputStream.readUnsignedShort();
    }

    public String toString() {
        String string = this.isResolved() ? "Method : Class = " + this.methodClassName + ", name = " + this.methodName + ", type = " + this.methodType : "Method : Class index = " + this.classIndex + ", name and type index = " + this.nameAndTypeIndex;
        return string;
    }

    public void resolve(ConstantPool constantPool) {
        ClassCPInfo classCPInfo = (ClassCPInfo)constantPool.getEntry(this.classIndex);
        classCPInfo.resolve(constantPool);
        this.methodClassName = classCPInfo.getClassName();
        NameAndTypeCPInfo nameAndTypeCPInfo = (NameAndTypeCPInfo)constantPool.getEntry(this.nameAndTypeIndex);
        nameAndTypeCPInfo.resolve(constantPool);
        this.methodName = nameAndTypeCPInfo.getName();
        this.methodType = nameAndTypeCPInfo.getType();
        super.resolve(constantPool);
    }

    public String getMethodClassName() {
        return this.methodClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodType() {
        return this.methodType;
    }
}

