/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontTrueType;
import org.apache.fop.pdf.PDFFontType1;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFFont
extends PDFObject {
    public static final byte TYPE0 = 0;
    public static final byte TYPE1 = 1;
    public static final byte MMTYPE1 = 2;
    public static final byte TYPE3 = 3;
    public static final byte TRUETYPE = 4;
    protected static final String[] TYPE_NAMES = new String[]{"Type0", "Type1", "MMType1", "Type3", "TrueType"};
    protected String fontname;
    protected byte subtype;
    protected String basefont;
    protected Object encoding;

    public PDFFont(int n, String string, byte by, String string2, Object object) {
        super(n);
        this.fontname = string;
        this.subtype = by;
        this.basefont = string2;
        this.encoding = object;
    }

    public static PDFFont createFont(int n, String string, byte by, String string2, Object object) {
        switch (by) {
            case 1: 
            case 2: {
                return new PDFFontType1(n, string, by, string2, object);
            }
            case 4: {
                return new PDFFontTrueType(n, string, by, string2, object);
            }
        }
        return null;
    }

    public static PDFFont createFont(int n, String string, byte by, String string2, Object object, int n2, int n3, PDFArray pDFArray, PDFFontDescriptor pDFFontDescriptor) {
        switch (by) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: {
                PDFFontType1 pDFFontType1 = new PDFFontType1(n, string, by, string2, object);
                pDFFontType1.setWidthMetrics(n2, n3, pDFArray);
                pDFFontType1.setDescriptor(pDFFontDescriptor);
                return pDFFontType1;
            }
            case 3: {
                return null;
            }
            case 4: {
                PDFFontTrueType pDFFontTrueType = new PDFFontTrueType(n, string, by, string2, object);
                pDFFontTrueType.setWidthMetrics(n2, n3, pDFArray);
                pDFFontTrueType.setDescriptor(pDFFontDescriptor);
                return pDFFontTrueType;
            }
        }
        return null;
    }

    protected void fillInPDF(StringBuffer stringBuffer) {
    }

    public String getName() {
        return this.fontname;
    }

    public byte[] toPDF() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.number) + " " + this.generation + " obj\n<< /Type /Font\n/Subtype /" + TYPE_NAMES[this.subtype] + "\n/Name /" + this.fontname + "\n/BaseFont /" + this.basefont);
        if (this.encoding != null) {
            stringBuffer.append("\n/Encoding ");
            if (this.encoding instanceof PDFEncoding) {
                stringBuffer.append(((PDFEncoding)this.encoding).referencePDF());
            } else if (this.encoding instanceof PDFStream) {
                stringBuffer.append(((PDFStream)this.encoding).referencePDF());
            } else {
                stringBuffer.append("/").append((String)this.encoding);
            }
        }
        this.fillInPDF(stringBuffer);
        stringBuffer.append(" >>\nendobj\n");
        return stringBuffer.toString().getBytes();
    }
}

