/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;

public class RepeatablePageMasterReference
extends PageMasterReference
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private PageSequenceMaster pageSequenceMaster;
    private int maximumRepeats;
    private int numberConsumed = 0;

    public RepeatablePageMasterReference(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        String string = this.getProperty("maximum-repeats").getString();
        if (string.equals("no-limit")) {
            this.setMaximumRepeats(-1);
        } else {
            try {
                this.setMaximumRepeats(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FOPException("Invalid number for 'maximum-repeats' property");
            }
        }
    }

    protected String getElementName() {
        return "fo:repeatable-page-master-reference";
    }

    private int getMaximumRepeats() {
        return this.maximumRepeats;
    }

    public String getNextPageMaster(int n, boolean bl, boolean bl2) {
        String string = this.getMasterName();
        if (this.getMaximumRepeats() != -1) {
            if (this.numberConsumed < this.getMaximumRepeats()) {
                ++this.numberConsumed;
            } else {
                string = null;
            }
        }
        return string;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void reset() {
        this.numberConsumed = 0;
    }

    private void setMaximumRepeats(int n) {
        this.maximumRepeats = n == -1 ? n : (n < 0 ? 0 : n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new RepeatablePageMasterReference(fObj, propertyList);
        }
    }
}

