/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.ClipKey;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGClipDescriptor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGClip
extends AbstractSVGConverter {
    public static final SVGClipDescriptor NO_CLIP = new SVGClipDescriptor("none", null);
    private SVGShape shapeConverter;

    public SVGClip(Document document) {
        super(document);
        this.shapeConverter = new SVGShape(document);
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Shape shape = graphicContext.getClip();
        return this.toSVG(shape);
    }

    public SVGClipDescriptor toSVG(Shape shape) {
        SVGClipDescriptor sVGClipDescriptor = null;
        if (shape != null) {
            StringBuffer stringBuffer = new StringBuffer("url(");
            GeneralPath generalPath = new GeneralPath(shape);
            ClipKey clipKey = new ClipKey(generalPath);
            sVGClipDescriptor = (SVGClipDescriptor)this.descMap.get(clipKey);
            if (sVGClipDescriptor == null) {
                Element element = this.clipToSVG(shape);
                stringBuffer.append("#");
                stringBuffer.append(element.getAttributeNS(null, "id"));
                stringBuffer.append(")");
                sVGClipDescriptor = new SVGClipDescriptor(stringBuffer.toString(), element);
                this.descMap.put(clipKey, sVGClipDescriptor);
                this.defSet.add(element);
            }
        } else {
            sVGClipDescriptor = NO_CLIP;
        }
        return sVGClipDescriptor;
    }

    private Element clipToSVG(Shape shape) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "clipPath");
        element.setAttributeNS(null, "clipPathUnits", "userSpaceOnUse");
        element.setAttributeNS(null, "id", SVGIDGenerator.generateID("clipPath"));
        Element element2 = this.shapeConverter.toSVG(shape);
        element.appendChild(element2);
        return element;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Element element;
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(2, 1);
        polygon.addPoint(3, 2);
        polygon.addPoint(3, 3);
        polygon.addPoint(2, 4);
        polygon.addPoint(1, 3);
        polygon.addPoint(1, 2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(1.0f, 0.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(0.0f, 1.0f);
        generalPath.closePath();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        Area area = new Area(generalPath);
        area.subtract(new Area(double_));
        ClipKey clipKey = new ClipKey(new GeneralPath(polygon));
        ClipKey clipKey2 = new ClipKey(new GeneralPath(polygon));
        System.out.println("key1.equals(key2) = " + clipKey.equals(clipKey2));
        int n = clipKey.hashCode();
        int n2 = clipKey2.hashCode();
        System.out.println("hash1 = " + n);
        System.out.println("hash2 = " + n2);
        Shape[] shapeArray = new Shape[]{polygon, new Rectangle(10, 20, 30, 40), new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0), new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f), new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0), new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f), new Line2D.Double(1.0, 2.0, 3.0, 4.0), new Line2D.Double(10.0, 20.0, 30.0, 40.0), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f), new Arc2D.Double(0.0, 0.0, 100.0, 100.0, 0.0, 90.0, 0), generalPath, area};
        Document document = TestUtil.getDocumentPrototype();
        SVGClip sVGClip = new SVGClip(document);
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n3 = 0;
        while (n3 < shapeArray.length) {
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "id", shapeArray[n3].getClass().getName());
            element.setAttributeNS(null, "clip-path", (String)sVGClip.toSVG(shapeArray[n3]).getAttributeMap(null).get("clip-path"));
            element4.appendChild(element);
            ++n3;
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n4 = 0;
        while (n4 < shapeArray.length) {
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "id", shapeArray[n4].getClass().getName());
            object.setAttributeNS(null, "clip-path", (String)sVGClip.toSVG(shapeArray[n4]).getAttributeMap(null).get("clip-path"));
            element.appendChild((Node)object);
            ++n4;
        }
        object = sVGClip.getDefinitionSet().iterator();
        while (object.hasNext()) {
            Element element5 = (Element)object.next();
            element3.appendChild(element5);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element);
        TestUtil.trace(element2, System.out);
    }
}

