/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.CompositeRule;

public class SVGComposite
implements Composite {
    public static final SVGComposite OVER = new SVGComposite(CompositeRule.OVER);
    public static final SVGComposite IN = new SVGComposite(CompositeRule.IN);
    public static final SVGComposite OUT = new SVGComposite(CompositeRule.OUT);
    public static final SVGComposite ATOP = new SVGComposite(CompositeRule.ATOP);
    public static final SVGComposite XOR = new SVGComposite(CompositeRule.XOR);
    public static final SVGComposite MULTIPLY = new SVGComposite(CompositeRule.MULTIPLY);
    public static final SVGComposite SCREEN = new SVGComposite(CompositeRule.SCREEN);
    public static final SVGComposite DARKEN = new SVGComposite(CompositeRule.DARKEN);
    public static final SVGComposite LIGHTEN = new SVGComposite(CompositeRule.LIGHTEN);
    CompositeRule rule;

    public CompositeRule getRule() {
        return this.rule;
    }

    public SVGComposite(CompositeRule compositeRule) {
        this.rule = compositeRule;
    }

    public boolean equals(Object object) {
        if (object instanceof SVGComposite) {
            SVGComposite sVGComposite = (SVGComposite)object;
            return sVGComposite.getRule() == this.getRule();
        }
        if (object instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)object;
            switch (this.getRule().getRule()) {
                case 1: {
                    return alphaComposite == AlphaComposite.SrcOver;
                }
                case 2: {
                    return alphaComposite == AlphaComposite.SrcIn;
                }
                case 3: {
                    return alphaComposite == AlphaComposite.SrcOut;
                }
            }
            return false;
        }
        return false;
    }

    public boolean is_INT_PACK(ColorModel colorModel) {
        if (!(colorModel instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)colorModel;
        int[] nArray = packedColorModel.getMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray[3] == -16777216;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        boolean bl = this.is_INT_PACK(colorModel) && this.is_INT_PACK(colorModel2);
        switch (this.rule.getRule()) {
            case 1: {
                if (bl) {
                    return new OverCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new OverCompositeContext(colorModel, colorModel2);
            }
            case 2: {
                return new InCompositeContext(colorModel, colorModel2);
            }
            case 3: {
                return new OutCompositeContext(colorModel, colorModel2);
            }
            case 4: {
                return new AtopCompositeContext(colorModel, colorModel2);
            }
            case 5: {
                return new XorCompositeContext(colorModel, colorModel2);
            }
            case 6: {
                float[] fArray = this.rule.getCoefficients();
                return new ArithCompositeContext(colorModel, colorModel2, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            case 7: {
                return new MultiplyCompositeContext(colorModel, colorModel2);
            }
            case 8: {
                return new ScreenCompositeContext(colorModel, colorModel2);
            }
            case 9: {
                return new DarkenCompositeContext(colorModel, colorModel2);
            }
            case 10: {
                return new LightenCompositeContext(colorModel, colorModel2);
            }
        }
        throw new UnsupportedOperationException("Unknown composite rule requested.");
    }

    public static class LightenCompositeContext
    extends AlphaPreCompositeContext {
        LightenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = n6 + 3;
                    int n9 = 255 - nArray2[n8];
                    int n10 = 255 - nArray[n8];
                    while (n6 < n8) {
                        int n11 = n9 * nArray[n6] / 255 + nArray2[n6];
                        int n12 = n10 * nArray2[n6] / 255 + nArray[n6];
                        nArray2[n6] = n11 > n12 ? n11 : n12;
                        ++n6;
                    }
                    nArray2[n6] = nArray[n6] + nArray2[n6] - nArray2[n6] * nArray[n6] / 255;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class DarkenCompositeContext
    extends AlphaPreCompositeContext {
        DarkenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = n6 + 3;
                    int n9 = 255 - nArray2[n8];
                    int n10 = 255 - nArray[n8];
                    while (n6 < n8) {
                        int n11 = n9 * nArray[n6] / 255 + nArray2[n6];
                        int n12 = n10 * nArray2[n6] / 255 + nArray[n6];
                        nArray2[n6] = n11 > n12 ? n12 : n11;
                        ++n6;
                    }
                    nArray2[n6] = nArray[n6] + nArray2[n6] - nArray2[n6] * nArray[n6] / 255;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class ScreenCompositeContext
    extends AlphaPreCompositeContext {
        ScreenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    nArray2[n6] = nArray[n6] + nArray2[n6] - nArray[n6] * nArray2[n6] / 255;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - nArray[n6] * nArray2[n6] / 255;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - nArray[n6] * nArray2[n6] / 255;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - nArray2[n6] * nArray[n6] / 255;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class MultiplyCompositeContext
    extends AlphaPreCompositeContext {
        MultiplyCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = 255 - nArray2[n6 + 3];
                    int n9 = 255 - nArray[n6 + 3];
                    nArray2[n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) / 255;
                    nArray2[++n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) / 255;
                    nArray2[++n6] = (nArray[n6] * n8 + nArray2[n6] * n9 + nArray[n6] * nArray2[n6]) / 255;
                    nArray2[++n6] = nArray[n6] + nArray2[n6] - nArray2[n6] * nArray[n6] / 255;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class ArithCompositeContext
    extends AlphaPreCompositeContext {
        float k1;
        float k2;
        float k3;
        float k4;

        ArithCompositeContext(ColorModel colorModel, ColorModel colorModel2, float f, float f2, float f3, float f4) {
            super(colorModel, colorModel2);
            this.k1 = f;
            this.k2 = f2;
            this.k3 = f3;
            this.k4 = f4;
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            float f = this.k1 / 255.0f;
            float f2 = this.k4 * 255.0f + 0.5f;
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                while (n6 < nArray.length) {
                    nArray2[n6] = (int)(f * (float)nArray[n6] * (float)nArray2[n6] + this.k2 * (float)nArray[n6] + this.k3 * (float)nArray2[n6] + f2);
                    if (nArray2[n6] < 0) {
                        nArray2[n6] = 0;
                    } else if (nArray2[n6] > 255) {
                        nArray2[n6] = 255;
                    }
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class XorCompositeContext
    extends AlphaPreCompositeContext {
        XorCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray2[n6 + 3]) * 65793;
                    int n9 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class AtopCompositeContext
    extends AlphaPreCompositeContext {
        AtopCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = nArray2[n6 + 3] * 65793;
                    int n9 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + nArray2[n6] * n9 + 0x800000 >>> 24;
                    n6 += 2;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class OutCompositeContext
    extends AlphaPreCompositeContext {
        OutCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray2[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class InCompositeContext
    extends AlphaPreCompositeContext {
        InCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = nArray2[n6 + 3] * 65793;
                    nArray2[n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    nArray2[++n6] = nArray[n6] * n8 + 0x800000 >>> 24;
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK
    extends AlphaPreCompositeContext {
        OverCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
            int n5 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n6 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster2.getSampleModel();
            int n7 = singlePixelPackedSampleModel2.getScanlineStride();
            DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
            int[] nArray2 = dataBufferInt2.getBankData()[0];
            int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n - raster2.getSampleModelTranslateX(), n3 - raster2.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel3 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int n9 = singlePixelPackedSampleModel3.getScanlineStride();
            DataBufferInt dataBufferInt3 = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray3 = dataBufferInt3.getBankData()[0];
            int n10 = dataBufferInt3.getOffset() + singlePixelPackedSampleModel3.getOffset(n - writableRaster.getSampleModelTranslateX(), n3 - writableRaster.getSampleModelTranslateY());
            int n11 = n5 - n2;
            int n12 = n7 - n2;
            int n13 = n9 - n2;
            int n14 = n6;
            int n15 = n8;
            int n16 = n10;
            int n17 = n3;
            while (n17 < n4) {
                int n18 = n16 + n2;
                while (n16 < n18) {
                    int n19 = nArray[n14++];
                    int n20 = nArray2[n15++];
                    int n21 = (255 - (n19 >>> 24)) * 65793;
                    int n22 = (n19 & 0xFF000000) + ((n20 >>> 24) * n21 + 0x800000) & 0xFF000000;
                    int n23 = (n19 & 0xFF0000) + ((n20 >> 16 & 0xFF) * n21 + 0x800000 >> 8) & 0xFF0000;
                    int n24 = (n19 & 0xFF00) + ((n20 >> 8 & 0xFF) * n21 + 0x800000 >> 16) & 0xFF00;
                    int n25 = (n19 & 0xFF) + ((n20 & 0xFF) * n21 + 0x800000 >>> 24);
                    nArray3[n16++] = n22 | n23 | n24 | n25;
                }
                n14 += n11;
                n15 += n12;
                n16 += n13;
                ++n17;
            }
        }
    }

    public static class OverCompositeContext
    extends AlphaPreCompositeContext {
        OverCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n = writableRaster.getMinX();
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getMinY();
            int n4 = n3 + writableRaster.getHeight();
            int n5 = n3;
            while (n5 < n4) {
                nArray = raster.getPixels(n, n5, n2, 1, nArray);
                nArray2 = raster2.getPixels(n, n5, n2, 1, nArray2);
                int n6 = 0;
                int n7 = n2 * 4;
                while (n6 < n7) {
                    int n8 = (255 - nArray[n6 + 3]) * 65793;
                    nArray2[n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    nArray2[++n6] = nArray[n6] + (nArray2[n6] * n8 + 0x800000 >>> 24);
                    ++n6;
                }
                writableRaster.setPixels(n, n5, n2, 1, nArray2);
                ++n5;
            }
        }
    }

    public static abstract class AlphaPreCompositeContext
    implements CompositeContext {
        ColorModel srcCM;
        ColorModel dstCM;

        AlphaPreCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            this.srcCM = colorModel;
            this.dstCM = colorModel2;
        }

        public void dispose() {
            this.srcCM = null;
            this.dstCM = null;
        }

        protected abstract void precompose(Raster var1, Raster var2, WritableRaster var3);

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            ColorModel colorModel = this.srcCM;
            if (!this.srcCM.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceData((WritableRaster)raster, this.srcCM, true);
            }
            ColorModel colorModel2 = this.dstCM;
            if (!this.dstCM.isAlphaPremultiplied()) {
                colorModel2 = GraphicsUtil.coerceData((WritableRaster)raster2, this.dstCM, true);
            }
            this.precompose(raster, raster2, writableRaster);
            if (!this.srcCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
            }
            if (!this.dstCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData(writableRaster, colorModel2, false);
                if (raster2 != writableRaster) {
                    GraphicsUtil.coerceData((WritableRaster)raster2, colorModel2, false);
                }
            }
        }
    }
}

