/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Color;
import org.apache.batik.ext.awt.image.renderable.Light;

public class DistantLight
implements Light {
    private double azimuth;
    private double elevation;
    private double Lx;
    private double Ly;
    private double Lz;
    private double[] color;

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double[] getColor() {
        return this.color;
    }

    public DistantLight(double d, double d2, Color color) {
        this.azimuth = d;
        this.elevation = d2;
        this.setColor(color);
        this.Lx = Math.cos(Math.PI * d / 180.0) * Math.cos(Math.PI * d2 / 180.0);
        this.Ly = Math.sin(Math.PI * d / 180.0) * Math.cos(Math.PI * d2 / 180.0);
        this.Lz = Math.sin(Math.PI * d2 / 180.0);
    }

    public void setColor(Color color) {
        double[] dArray = new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
        this.color = dArray;
    }

    public boolean isConstant() {
        return true;
    }

    public void getLight(double d, double d2, double d3, double[] dArray) {
        dArray[0] = this.Lx;
        dArray[1] = this.Ly;
        dArray[2] = this.Lz;
    }

    public double[][][] getLightMap(double d, double d2, double d3, double d4, int n, int n2, double[][][] dArray) {
        double[][][] dArrayArray = new double[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            dArrayArray[n3] = this.getLightRow(d, d2, d3, n, dArray[n3], null);
            d2 += d4;
            ++n3;
        }
        return dArrayArray;
    }

    public double[][] getLightRow(double d, double d2, double d3, int n, double[][] dArray, double[][] dArray2) {
        Object object = dArray2;
        if (object == null) {
            object = new double[n][];
            double[] dArray3 = new double[3];
            this.getLight(0.0, 0.0, 0.0, dArray3);
            int n2 = 0;
            while (n2 < n) {
                object[n2] = dArray3;
                ++n2;
            }
        } else {
            double d4 = this.Lx;
            double d5 = this.Ly;
            double d6 = this.Lz;
            int n3 = 0;
            while (n3 < n) {
                object[n3][0] = d4;
                object[n3][1] = d5;
                object[n3][2] = d6;
                ++n3;
            }
        }
        return object;
    }
}

