/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.renderable.ARGBChannel;

public class DisplacementMapOp
implements RasterOp {
    private static final boolean TIME = false;
    private static final boolean USE_NN = false;
    private int scaleX;
    private int scaleY;
    private ARGBChannel xChannel;
    private ARGBChannel yChannel;
    Raster in2;

    public DisplacementMapOp(ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2, int n, int n2, Raster raster) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException();
        }
        if (aRGBChannel2 == null) {
            throw new IllegalArgumentException();
        }
        this.in2 = raster;
        this.scaleX = n;
        this.scaleY = n2;
        this.xChannel = aRGBChannel;
        this.yChannel = aRGBChannel2;
    }

    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(this.in2.getMinX(), this.in2.getMinY(), this.in2.getWidth(), this.in2.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("DisplacementMapOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n != 4) {
            throw new IllegalArgumentException("DisplacementMapOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("DisplacementMapOp only works with Rasters using DataBufferInts");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] % 8 != 0) {
                throw new IllegalArgumentException("DisplacementMapOp only works with Rasters using 8 bits per band : " + n2 + " : " + nArray[n2]);
            }
            ++n2;
        }
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel().createCompatibleSampleModel(this.in2.getWidth(), this.in2.getHeight());
        return Raster.createWritableRaster(sampleModel, new Point(this.in2.getMinX(), this.in2.getMinY()));
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        return this.filterBL(raster, writableRaster);
    }

    public WritableRaster filterBL(Raster raster, WritableRaster writableRaster) {
        int n = this.in2.getWidth();
        int n2 = this.in2.getHeight();
        int n3 = this.in2.getMinX() - raster.getMinX();
        int n4 = this.in2.getMinY() - raster.getMinY();
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt3 = (DataBufferInt)this.in2.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel.getOffset(this.in2.getMinX() - writableRaster.getSampleModelTranslateX(), this.in2.getMinY() - writableRaster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.in2.getSampleModel();
        int n9 = dataBufferInt3.getOffset() + singlePixelPackedSampleModel.getOffset(this.in2.getMinX() - this.in2.getSampleModelTranslateX(), this.in2.getMinY() - this.in2.getSampleModelTranslateY());
        int n10 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n11 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n12 = ((SinglePixelPackedSampleModel)this.in2.getSampleModel()).getScanlineStride();
        int n13 = n11 - n;
        int n14 = n12 - n;
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = dataBufferInt3.getBankData()[0];
        int n15 = this.xChannel.toInt() * 8;
        int n16 = this.yChannel.toInt() * 8;
        int n17 = n7;
        int n18 = n8;
        int n19 = n9;
        int n20 = this.scaleX * 65536 / 255;
        int n21 = this.scaleY * 65536 / 255;
        int n22 = this.scaleX / 2 + 1;
        int n23 = n - n22;
        int n24 = this.scaleY / 2 + 1;
        int n25 = n2 - n24;
        long l = System.currentTimeMillis();
        int n26 = raster.getWidth() - 1;
        int n27 = raster.getHeight() - 1;
        int n28 = n4;
        while (n28 < n6) {
            int n29 = n3;
            while (n29 < n5) {
                int n30 = nArray3[n19];
                int n31 = n20 * ((n30 >> n15 & 0xFF) - 127);
                int n32 = n21 * ((n30 >> n16 & 0xFF) - 127);
                int n33 = n29 + (n31 >> 16);
                int n34 = n28 + (n32 >> 16);
                if (n33 < 0 || n33 > n26 || n34 < 0 || n34 > n27) {
                    nArray2[n18] = 0;
                } else {
                    int n35;
                    int n36 = n7 + n34 * n10 + n33;
                    int n37 = nArray[n36];
                    int n38 = n37 >>> 16 & 0xFF00;
                    int n39 = n37 >> 8 & 0xFF00;
                    int n40 = n37 & 0xFF00;
                    int n41 = n37 << 8 & 0xFF00;
                    if (n33 != n26) {
                        n37 = nArray[n36 + 1];
                    }
                    int n42 = n37 >>> 16 & 0xFF00;
                    int n43 = n37 >> 8 & 0xFF00;
                    int n44 = n37 & 0xFF00;
                    int n45 = n37 << 8 & 0xFF00;
                    int n46 = n31 & 0xFFFF;
                    int n47 = n38 + ((n42 - n38) * n46 >> 16) & 0xFFFF;
                    int n48 = n39 + ((n43 - n39) * n46 >> 16) & 0xFFFF;
                    int n49 = n40 + ((n44 - n40) * n46 >> 16) & 0xFFFF;
                    int n50 = n41 + ((n45 - n41) * n46 >> 16) & 0xFFFF;
                    if (n34 != n27) {
                        n36 += n10;
                    }
                    n37 = nArray[n36];
                    n38 = n37 >>> 16 & 0xFF00;
                    n39 = n37 >> 8 & 0xFF00;
                    n40 = n37 & 0xFF00;
                    n41 = n37 << 8 & 0xFF00;
                    if (n33 != n26) {
                        n37 = nArray[n36 + 1];
                    }
                    n42 = n37 >>> 16 & 0xFF00;
                    n43 = n37 >> 8 & 0xFF00;
                    n44 = n37 & 0xFF00;
                    n45 = n37 << 8 & 0xFF00;
                    int n51 = n38 + ((n42 - n38) * n46 >> 16) & 0xFFFF;
                    int n52 = n39 + ((n43 - n39) * n46 >> 16) & 0xFFFF;
                    int n53 = n40 + ((n44 - n40) * n46 >> 16) & 0xFFFF;
                    int n54 = n41 + ((n45 - n41) * n46 >> 16) & 0xFFFF;
                    n46 = n32 & 0xFFFF;
                    nArray2[n18] = n35 = (n47 << 16) + (n51 - n47) * n46 & 0xFF000000 | ((n48 << 16) + (n52 - n48) * n46 & 0xFF000000) >>> 8 | ((n49 << 16) + (n53 - n49) * n46 & 0xFF000000) >>> 16 | (n50 << 16) + (n54 - n50) * n46 >>> 24;
                }
                ++n18;
                ++n19;
                ++n29;
            }
            n18 += n13;
            n19 += n14;
            ++n28;
        }
        return writableRaster;
    }

    public WritableRaster filterNN(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.in2.getWidth();
        int n9 = this.in2.getHeight();
        int n10 = this.in2.getMinX() - raster.getMinX();
        int n11 = this.in2.getMinY() - raster.getMinY();
        int n12 = n10 + n8;
        int n13 = n11 + n9;
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt3 = (DataBufferInt)this.in2.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n14 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n15 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel.getOffset(this.in2.getMinX() - writableRaster.getSampleModelTranslateX(), this.in2.getMinY() - writableRaster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.in2.getSampleModel();
        int n16 = dataBufferInt3.getOffset() + singlePixelPackedSampleModel.getOffset(this.in2.getMinX() - this.in2.getSampleModelTranslateX(), this.in2.getMinY() - this.in2.getSampleModelTranslateY());
        int n17 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n18 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n19 = ((SinglePixelPackedSampleModel)this.in2.getSampleModel()).getScanlineStride();
        int n20 = n18 - n8;
        int n21 = n19 - n8;
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = dataBufferInt3.getBankData()[0];
        int n22 = this.xChannel.toInt() * 8;
        int n23 = this.yChannel.toInt() * 8;
        int n24 = this.scaleX * 65536 / 255;
        int n25 = this.scaleY * 65536 / 255;
        int n26 = raster.getWidth() - 1;
        int n27 = raster.getHeight() - 1;
        int n28 = this.scaleX / 2 + 1;
        int n29 = n26 - n28;
        if (n28 > n12) {
            n28 = n12;
        }
        if (n29 > n12) {
            n29 = n12;
        }
        int n30 = n28;
        int n31 = n29;
        n28 = this.scaleY / 2 + 1;
        n29 = n27 - n28;
        if (n28 > n13) {
            n28 = n13;
        }
        if (n29 > n13) {
            n29 = n13;
        }
        int n32 = n28;
        int n33 = n29;
        int n34 = n15;
        int n35 = n16;
        long l = System.currentTimeMillis();
        int n36 = n11;
        while (n36 < n32) {
            n7 = n10;
            while (n7 < n30) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 < 0 || n3 > n26 || n2 < 0 || n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n31) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n2 < 0 || n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n12) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 > n26 || n2 < 0 || n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            n34 += n20;
            n35 += n21;
            ++n36;
        }
        while (n36 < n33) {
            n7 = n10;
            while (n7 < n30) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 < 0 || n3 > n26) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n31) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n14 + n7 + (n5 >> 16) + (n36 + (n4 >> 16)) * n17;
                nArray2[n34] = nArray[n3];
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n12) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 > n26) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            n34 += n20;
            n35 += n21;
            ++n36;
        }
        while (n36 < n13) {
            n7 = n10;
            while (n7 < n30) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 < 0 || n3 > n26 || n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n31) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            while (n7 < n12) {
                n6 = nArray3[n35];
                n5 = n24 * ((n6 >> n22 & 0xFF) - 127);
                n4 = n25 * ((n6 >> n23 & 0xFF) - 127);
                n3 = n7 + (n5 >> 16);
                n2 = n36 + (n4 >> 16);
                if (n3 > n26 || n2 > n27) {
                    nArray2[n34] = 0;
                } else {
                    n = n14 + n2 * n17 + n3;
                    nArray2[n34] = nArray[n];
                }
                ++n34;
                ++n35;
                ++n7;
            }
            n34 += n20;
            n35 += n21;
            ++n36;
        }
        return writableRaster;
    }
}

