/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRule;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.renderable.SVGComposite;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.CompositeRed;
import org.apache.batik.ext.awt.image.rendered.FloodRed;

public class CompositeRable8Bit
extends AbstractRable
implements CompositeRable,
PaintRable {
    protected CompositeRule rule;
    protected ColorSpace colorspace;
    protected boolean csIsLinear;

    public CompositeRable8Bit(List list, CompositeRule compositeRule, boolean bl) {
        super(list);
        this.rule = compositeRule;
        this.csIsLinear = bl;
        this.colorspace = bl ? ColorSpace.getInstance(1004) : ColorSpace.getInstance(1000);
    }

    public void setSources(List list) {
        this.init(list, null);
    }

    public void setCompositeRule(CompositeRule compositeRule) {
        this.touch();
        this.rule = this.rule;
    }

    public CompositeRule getCompositeRule() {
        return this.rule;
    }

    public void setCompositeColorSpace(ColorSpace colorSpace) {
        this.touch();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            this.csIsLinear = true;
        } else if (colorSpace == ColorSpace.getInstance(1000)) {
            this.csIsLinear = false;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for Composite: " + colorSpace);
        }
        this.colorspace = colorSpace;
    }

    public ColorSpace getCompositeColorSpace() {
        return this.colorspace;
    }

    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        if (this.getCompositeRule() != CompositeRule.OVER) {
            return false;
        }
        ColorSpace colorSpace = this.getCompositeColorSpace();
        ColorSpace colorSpace2 = GraphicsUtil.getDestinationColorSpace(graphics2D);
        if (colorSpace2 == null || colorSpace2 != colorSpace) {
            return false;
        }
        Iterator iterator = ((AbstractList)this.getSources()).iterator();
        while (iterator.hasNext()) {
            GraphicsUtil.drawImage(graphics2D, (Filter)iterator.next());
        }
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        if (this.srcs.size() == 0) {
            return null;
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        Rectangle2D rectangle2D2 = renderContext.getAreaOfInterest().getBounds2D();
        if (rectangle2D2 != null) {
            rectangle2D = this.getBounds2D();
            if (!rectangle2D.intersects(rectangle2D2)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        }
        rectangle2D = affineTransform.createTransformedShape(rectangle2D2).getBounds();
        renderContext = new RenderContext(affineTransform, rectangle2D2, renderingHints);
        Vector<CachableRed> vector = new Vector<CachableRed>();
        Iterator iterator = ((AbstractList)this.getSources()).iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            RenderedImage renderedImage = filter.createRendering(renderContext);
            if (renderedImage != null) {
                CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
                cachableRed = this.csIsLinear ? GraphicsUtil.convertToLsRGB(cachableRed) : GraphicsUtil.convertTosRGB(cachableRed);
                vector.add(cachableRed);
                continue;
            }
            switch (this.rule.getRule()) {
                case 2: {
                    return null;
                }
                case 3: {
                    vector.clear();
                    break;
                }
                case 6: {
                    vector.add(new FloodRed((Rectangle)rectangle2D));
                    break;
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return new CompositeRed(vector, this.rule);
    }
}

