/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.ImmutableInherit;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.ViewCSS;

public class CSSOMReadOnlyStyleDeclaration
implements CSSStyleDeclaration {
    public static final int USER_AGENT_ORIGIN = 0;
    public static final int USER_ORIGIN = 1;
    public static final int AUTHOR_ORIGIN = 2;
    protected PropertyMap properties = new PropertyMap();
    protected ViewCSS viewCSS;
    protected Element parentElement;

    public CSSOMReadOnlyStyleDeclaration(ViewCSS viewCSS, Element element) {
        this.setContext(viewCSS, element);
    }

    public void setContext(ViewCSS viewCSS, Element element) {
        this.viewCSS = viewCSS;
        this.parentElement = HiddenChildElementSupport.getParentElement(element);
    }

    public String getCssText() {
        String string = "";
        int n = this.properties.size() - 1;
        while (n >= 0) {
            string = string + "    " + this.properties.key(n) + ": ";
            ValueEntry valueEntry = (ValueEntry)this.properties.item(n);
            if (valueEntry.getValue() != null) {
                string = string + valueEntry.getValue().getCssText();
            }
            string = string + valueEntry.getPriority() + ";\n";
            --n;
        }
        return string;
    }

    public void setCssText(String string) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public String getPropertyValue(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        if (valueEntry == null) {
            return "";
        }
        if (valueEntry.getValue() == null || valueEntry.getValue() == ImmutableInherit.INSTANCE) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return cSSStyleDeclaration.getPropertyCSSValue(string2).getCssText();
        }
        return valueEntry.getValue().getCssText();
    }

    public CSSValue getPropertyCSSValue(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        if (valueEntry == null) {
            return null;
        }
        if (valueEntry.getValue() == null) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            CSSOMReadOnlyValue cSSOMReadOnlyValue = (CSSOMReadOnlyValue)cSSStyleDeclaration.getPropertyCSSValue(string2);
            CSSOMReadOnlyValue cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(cSSOMReadOnlyValue.getImmutableValue());
            valueEntry.setValue(cSSOMReadOnlyValue2);
            return cSSOMReadOnlyValue2;
        }
        return valueEntry.getValue();
    }

    public CSSValue getLocalPropertyCSSValue(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        return valueEntry == null ? null : valueEntry.getValue();
    }

    public void setPropertyCSSValue(String string, CSSValue cSSValue, String string2, int n) {
        this.properties.put(string, this.createValueEntry(cSSValue, string2, n));
    }

    public int getPropertyOrigin(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        if (valueEntry == null) {
            return 2;
        }
        if (valueEntry.getValue() == null || valueEntry.getValue() == ImmutableInherit.INSTANCE) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return ((CSSOMReadOnlyStyleDeclaration)cSSStyleDeclaration).getPropertyOrigin(string2);
        }
        return valueEntry.getOrigin();
    }

    public int getLocalPropertyOrigin(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        return valueEntry == null ? 2 : valueEntry.getOrigin();
    }

    public String removeProperty(String string) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public String getPropertyPriority(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        if (valueEntry == null) {
            return "";
        }
        if (valueEntry.getValue() == null || valueEntry.getValue() == ImmutableInherit.INSTANCE) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return ((CSSOMReadOnlyStyleDeclaration)cSSStyleDeclaration).getPropertyPriority(string2);
        }
        return valueEntry.getPriority();
    }

    public String getLocalPropertyPriority(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string2);
        return valueEntry == null ? "" : valueEntry.getPriority();
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public int getLength() {
        return this.properties.size();
    }

    public String item(int n) {
        String string = (String)this.properties.key(n);
        return string == null ? "" : string;
    }

    public CSSRule getParentRule() {
        return null;
    }

    protected ValueEntry createValueEntry(CSSValue cSSValue, String string, int n) {
        switch (n) {
            case 0: {
                if (string.length() == 0) {
                    return new UserAgentValueEntry(cSSValue);
                }
                return new ImportantUserAgentValueEntry(cSSValue);
            }
            case 1: {
                if (string.length() == 0) {
                    return new UserValueEntry(cSSValue);
                }
                return new ImportantUserValueEntry(cSSValue);
            }
            case 2: {
                if (string.length() == 0) {
                    return new AuthorValueEntry(cSSValue);
                }
                return new ImportantAuthorValueEntry(cSSValue);
            }
        }
        throw new RuntimeException();
    }

    protected static class AuthorValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public AuthorValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 2;
        }
    }

    protected static class ImportantAuthorValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public ImportantAuthorValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 2;
        }
    }

    protected static class UserValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public UserValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 1;
        }
    }

    protected static class ImportantUserValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public ImportantUserValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 1;
        }
    }

    protected static class UserAgentValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public UserAgentValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 0;
        }
    }

    protected static class ImportantUserAgentValueEntry
    implements ValueEntry {
        protected CSSValue value;

        public ImportantUserAgentValueEntry(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public CSSValue getValue() {
            return this.value;
        }

        public void setValue(CSSValue cSSValue) {
            this.value = cSSValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 0;
        }
    }

    protected static interface ValueEntry {
        public CSSValue getValue();

        public void setValue(CSSValue var1);

        public String getPriority();

        public int getOrigin();
    }
}

