/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.io.StringReader;
import org.apache.batik.css.AbstractCSSRule;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMRuleList;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMStyleRule;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.CSSRuleListOwner;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.DocumentHandlerAdapter;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.css.value.ValueFactoryMap;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSOMMediaRule
extends AbstractCSSRule
implements CSSMediaRule,
CSSRuleListOwner {
    protected CSSOMRuleList cssRules = new CSSOMRuleList();
    protected Parser parser;
    protected ValueFactoryMap factories;
    protected MediaList media;
    protected DocumentHandler ruleHandler = new MediaRuleHandler();

    public CSSOMMediaRule(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, MediaList mediaList, Parser parser, ValueFactoryMap valueFactoryMap) {
        super(cSSStyleSheet, cSSRule);
        this.media = mediaList;
        this.parser = parser;
        this.factories = valueFactoryMap;
    }

    public Parser getParser() {
        return this.parser;
    }

    public ValueFactoryMap getValueFactoryMap() {
        return this.factories;
    }

    public short getType() {
        return 4;
    }

    public String getCssText() {
        String string = "@media " + this.media.getMediaText() + " {\n";
        int n = 0;
        while (n < this.cssRules.getLength()) {
            string = string + this.cssRules.item(n).getCssText() + "\n";
            ++n;
        }
        return string + "}";
    }

    public void setCssText(String string) throws DOMException {
        try {
            this.parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            this.parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            this.parser.setDocumentHandler(this.ruleHandler);
            this.parser.parseRule(new InputSource(new StringReader(string)));
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rule.syntax.error", new Object[]{string});
        }
    }

    public MediaList getMedia() {
        return this.media;
    }

    public CSSRuleList getCssRules() {
        return this.cssRules;
    }

    public int insertRule(String string, int n) throws DOMException {
        CSSOMStyleSheet cSSOMStyleSheet = (CSSOMStyleSheet)this.getParentStyleSheet();
        CSSRule cSSRule = CSSDocumentHandler.parseRule(cSSOMStyleSheet, string);
        if (cSSRule != null) {
            this.cssRules.insert(cSSRule, n);
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        this.cssRules.delete(n);
    }

    public void appendRule(CSSRule cSSRule) {
        this.cssRules.append(cSSRule);
    }

    protected class MediaRuleHandler
    extends DocumentHandlerAdapter {
        protected CSSRule currentRule;

        protected MediaRuleHandler() {
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            DOMMediaList dOMMediaList = new DOMMediaList();
            int n = 0;
            while (n < sACMediaList.getLength()) {
                dOMMediaList.appendMedium(sACMediaList.item(n));
                ++n;
            }
            CSSOMMediaRule.this.media = dOMMediaList;
            CSSOMMediaRule.this.cssRules = new CSSOMRuleList();
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.currentRule = new CSSOMStyleRule(CSSOMMediaRule.this.getParentStyleSheet(), CSSOMMediaRule.this, CSSOMMediaRule.this.getParser(), CSSOMMediaRule.this.getValueFactoryMap());
            CSSOMMediaRule.this.appendRule(this.currentRule);
            ((CSSOMStyleRule)this.currentRule).setSelectors(selectorList);
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            CSSOMStyleDeclaration cSSOMStyleDeclaration = (CSSOMStyleDeclaration)((CSSOMStyleRule)this.currentRule).getStyle();
            String string2 = bl ? "!important" : "";
            ValueFactory valueFactory = CSSOMMediaRule.this.getValueFactoryMap().get(string);
            valueFactory.createCSSValue(lexicalUnit, cSSOMStyleDeclaration, string2);
        }
    }
}

