/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGClipPathElementBridge
implements ClipBridge,
SVGConstants {
    public Clip createClip(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        Area area = new Area();
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        String string = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = string.length() > 0 ? SVGUtilities.convertAffineTransform(string) : new AffineTransform();
        String string2 = element.getAttributeNS(null, "clipPathUnits");
        if (string2.length() == 0) {
            string2 = "userSpaceOnUse";
        }
        try {
            n = SVGUtilities.parseCoordinateSystem(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("clipPath.units.invalid", new Object[]{string2, "clipPathUnits"}));
        }
        affineTransform = SVGUtilities.convertAffineTransform(affineTransform, graphicsNode, graphicsNodeRenderContext, n);
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                object4 = (Element)node;
                object3 = gVTBuilder.build(bridgeContext, (Element)object4);
                if (object3 == null) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("clipPath.subelement.illegal", new Object[]{node.getLocalName()}));
                }
                bl = true;
                object2 = CSSUtilities.getComputedStyle((Element)object4);
                object = (CSSPrimitiveValue)object2.getPropertyCSSValue("clip-rule");
                int n2 = CSSUtilities.rule((CSSPrimitiveValue)object) == 0 ? 1 : 0;
                GeneralPath generalPath = new GeneralPath(object3.getOutline(graphicsNodeRenderContext));
                generalPath.setWindingRule(n2);
                Shape shape = affineTransform.createTransformedShape(generalPath);
                ShapeNode shapeNode = new ShapeNode();
                shapeNode.setShape(shape);
                Clip clip = CSSUtilities.convertClipPath((Element)object4, shapeNode, bridgeContext);
                if (clip != null) {
                    Area area2 = new Area(shape);
                    area2.subtract(new Area(clip.getClipPath()));
                    shape = area2;
                }
                area.add(new Area(shape));
            }
            node = node.getNextSibling();
        }
        if (!bl) {
            return null;
        }
        object4 = new ShapeNode();
        ((ShapeNode)object4).setShape(area);
        object3 = CSSUtilities.convertClipPath(element, (GraphicsNode)object4, bridgeContext);
        if (object3 != null) {
            area.subtract(new Area(object3.getClipPath()));
        }
        if ((object2 = graphicsNode.getFilter()) == null) {
            object = bridgeContext.getGraphicsNodeRableFactory();
            object2 = object.createGraphicsNodeRable(graphicsNode, graphicsNodeRenderContext);
        }
        return new ClipRable8Bit((Filter)object2, area);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

