/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.language.java;

import java.io.File;
import java.util.Dictionary;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.processor.xsp.language.java.XSPJavaProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XSPJavaPreprocessor
implements XSPPreprocessor {
    protected static XSPJavaProcessor javaProcessor = new XSPJavaProcessor();

    public Document preprocess(Document document, Dictionary parameters) throws Exception {
        Element root = document.getDocumentElement();
        String filename = (String)parameters.get("filename");
        filename = new File(filename).getCanonicalPath();
        String packageName = XSPJavaProcessor.packageName(filename);
        String className = XSPJavaProcessor.className(filename);
        root.setAttribute("name", className);
        root.setAttribute("package", packageName);
        this.process(document);
        return document;
    }

    protected void process(Node node) {
        switch (node.getNodeType()) {
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                pi.setData(javaProcessor.stringEncode(pi.getData()));
                break;
            }
            case 3: {
                Element parent = (Element)node.getParentNode();
                String tagName = parent.getTagName();
                if (tagName.equals("xsp:expr") || tagName.equals("xsp:logic") || tagName.equals("xsp:structure") || tagName.equals("xsp:include")) {
                    return;
                }
                String value = javaProcessor.stringEncode(node.getNodeValue());
                Text textNode = node.getOwnerDocument().createTextNode(value);
                Element textElement = node.getOwnerDocument().createElement("xsp:text");
                textElement.appendChild(textNode);
                parent.replaceChild(textElement, node);
                break;
            }
            case 1: {
                ((Element)node).normalize();
            }
            default: {
                NodeList childList = node.getChildNodes();
                int childCount = childList.getLength();
                int i = 0;
                while (i < childCount) {
                    this.process(childList.item(i));
                    ++i;
                }
                break block0;
            }
        }
    }
}

