/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.cache;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Utils;
import org.apache.cocoon.cache.Cache;
import org.apache.cocoon.framework.Changeable;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Page;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.store.Store;

public class CocoonCache
implements Cache,
Status {
    private Store store;

    public void flush() {
        this.store.free();
    }

    public Page getPage(HttpServletRequest request) {
        Page page = (Page)this.store.get(Utils.encode(request));
        if (page == null) {
            return null;
        }
        boolean changed = false;
        Enumeration e = page.getChangeables();
        while (e.hasMoreElements()) {
            Changeable c = (Changeable)e.nextElement();
            changed = c.hasChanged(request);
            if (changed) break;
        }
        return changed ? null : page;
    }

    public String getStatus() {
        return "Cocoon Dynamic Cache System";
    }

    public void init(Director director) {
        this.store = (Store)director.getActor("store");
    }

    public void setPage(Page page, HttpServletRequest request) {
        if (!page.isCached()) {
            page.setCached(true);
            this.store.hold(Utils.encode(request), page);
        }
    }
}

