// 
// File:          Ordering_IntOrderTest_Impl.cc
// Symbol:        Ordering.IntOrderTest-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for Ordering.IntOrderTest
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "Ordering_IntOrderTest_Impl.hh"

#line 14 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._includes)
#include "sidl_int_IOR.h"
#include <stdlib.h>

static int32_t
iFunc(const int32_t *ind, const int32_t dim)
{
  int32_t res = 0;
  int32_t i;
  for(i = 0; i < dim ; ++i) {
    res += (i+1)*ind[i];
  }
  return res;
}

static int
incIndex(int32_t ind[], const struct sidl_int__array* A, const int32_t dimen)
{
  int32_t i = 0;
  while (i < dimen) {
    if (++(ind[i]) > sidlUpper(A, i)) {
      ind[i] = sidlLower(A, i);
      ++i;
    }
    else {
      return TRUE;
    }
  }
  /* we're all done */
  return FALSE;
}

static sidl_bool
isIMatrix(const struct sidl_int__array* A)
{
  if (A) {
    const int32_t dimen = sidl_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = (int32_t*)malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = sidlLower(A, i);
      if (sidlLower(A,i) > sidlUpper(A,i)) {
        free(cindex);
        return TRUE;
      }
    }
    do {
      if (iFunc(cindex, dimen) != sidl_int__array_get(A, cindex)) {
        free(cindex);
        return FALSE;
      }
    } while (incIndex(cindex, A, dimen));
    free(cindex);
    return TRUE;
  }
  return FALSE;
}

static void
fillIMatrix(struct sidl_int__array* A)
{
  if (A) {
    const int32_t dimen = sidl_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = (int32_t*)malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = sidlLower(A, i);
      if (sidlLower(A,i) > sidlUpper(A,i)){
        free(cindex);
        return;
      }
    }
    do {
      sidl_int__array_set(A, cindex, iFunc(cindex, dimen));
    } while (incIndex(cindex, A, dimen));
    free(cindex);
  }
}
// DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._includes)
#line 94 "Ordering_IntOrderTest_Impl.cc"

// user-defined constructor.
void Ordering::IntOrderTest_impl::_ctor() {
#line 96 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor)
#line 102 "Ordering_IntOrderTest_Impl.cc"
}

// user-defined destructor.
void Ordering::IntOrderTest_impl::_dtor() {
#line 103 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor)
#line 111 "Ordering_IntOrderTest_Impl.cc"
}

// static class initializer.
void Ordering::IntOrderTest_impl::_load() {
#line 110 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._load)
#line 120 "Ordering_IntOrderTest_Impl.cc"
}

// user-defined static methods:
/**
 * Create a column-major matrix satisfying condition I.
 */
::sidl::array<int32_t>
Ordering::IntOrderTest_impl::makeColumnIMatrix (
  /* in */ int32_t size,
  /* in */ bool useCreateCol ) 
throw () 
{
#line 125 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix)
  sidl::array<int32_t> res;
  if (useCreateCol) {
    res = sidl::array<int32_t>::create2dCol(size, size);
  }
  else {
    res = sidl::array<int32_t>::create2dRow(size, size);
  }
  fillIMatrix(res._get_ior());
  return res;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix)
#line 145 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Create a row-major matrix satisfying condition I.
 */
::sidl::array<int32_t>
Ordering::IntOrderTest_impl::makeRowIMatrix (
  /* in */ int32_t size,
  /* in */ bool useCreateRow ) 
throw () 
{
#line 147 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix)
  sidl::array<int32_t> res;
  if (useCreateRow) {
    res = sidl::array<int32_t>::create2dRow(size, size);
  }
  else {
    res = sidl::array<int32_t>::create2dCol(size, size);
  }
  fillIMatrix(res._get_ior());
  return res;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix)
#line 169 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Create a 4-D matrix satisfying condition I.  Each dimension has
 * size elements numbers 0 through size-1.
 */
::sidl::array<int32_t>
Ordering::IntOrderTest_impl::makeIMatrix (
  /* in */ int32_t size,
  /* in */ bool useCreateColumn ) 
throw () 
{
#line 170 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix)
  sidl::array<int32_t> res;
  static const int lower[4] = { 0, 0, 0, 0};
  const int upper[4] = { size - 1, size - 1, size -1, size - 1};
  if (useCreateColumn) {
    res = sidl::array<int32_t>::createCol(4, lower, upper);
  }
  else {
    res = sidl::array<int32_t>::createRow(4, lower, upper);
  }
  fillIMatrix(res._get_ior());
  return res;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix)
#line 196 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Create a column-major matrix satisfying condition I.
 */
void
Ordering::IntOrderTest_impl::createColumnIMatrix (
  /* in */ int32_t size,
  /* in */ bool useCreateCol,
  /* out */ ::sidl::array<int32_t>& res ) 
throw () 
{
#line 195 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix)
  if (useCreateCol){
    res = Ordering::IntOrderTest::makeColumnIMatrix(size, true);
  }
  else {
    res = Ordering::IntOrderTest::makeRowIMatrix(size, true);
  }
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix)
#line 218 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Create a row-major matrix satisfying condition I.
 */
void
Ordering::IntOrderTest_impl::createRowIMatrix (
  /* in */ int32_t size,
  /* in */ bool useCreateRow,
  /* out */ ::sidl::array<int32_t>& res ) 
throw () 
{
#line 215 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix)
  if (useCreateRow){
    res = Ordering::IntOrderTest::makeRowIMatrix(size, true);
  }
  else {
    res = Ordering::IntOrderTest::makeColumnIMatrix(size, true);
  }
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix)
#line 240 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Make sure an array is column-major.  No changes to the dimension or
 * values in a are made.
 */
void
Ordering::IntOrderTest_impl::ensureColumn (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 234 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn)
  /* no action required */
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn)
#line 256 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Make sure an array is row-major.  No changes to the dimension or
 * values in a are made.
 */
void
Ordering::IntOrderTest_impl::ensureRow (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 248 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow)
  /* no action required */
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow)
#line 272 "Ordering_IntOrderTest_Impl.cc"
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixOne (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 262 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne)
#line 288 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixOne (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 276 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne)
#line 304 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixOne (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 290 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne)
  bool i = A.isRowOrder();
  bool j = isIMatrix(A._get_ior());
  return (i && j);
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne)
#line 322 "Ordering_IntOrderTest_Impl.cc"
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixTwo (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 306 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo)
#line 338 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixTwo (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 320 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo)
#line 354 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixTwo (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 334 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo)
  bool i = A.isRowOrder();
  bool j = isIMatrix(A._get_ior());
  return (i && j);
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo)
#line 372 "Ordering_IntOrderTest_Impl.cc"
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixFour (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 350 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour)
#line 388 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixFour (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 364 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour)
#line 404 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixFour (
  /* in */ ::sidl::array<int32_t> A ) 
throw () 
{
#line 378 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour)
  return A.isRowOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour)
#line 420 "Ordering_IntOrderTest_Impl.cc"
}

/**
 * Return <code>true</code> iff the implementation of slice
 * and smart copy is correct.
 */
bool
Ordering::IntOrderTest_impl::isSliceWorking (
  /* in */ bool useCreateCol ) 
throw () 
{
#line 392 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking)
  bool res = true;
  const int32_t maxDim = 16;
  const int32_t halfDim = maxDim >> 1;
  sidl::array<int32_t> A, B;
  int32_t ind[2];
  int32_t stride[2] = {2, 2};
  int32_t numElem[2] = {halfDim, halfDim};
  int32_t newIndex[2];
  if (useCreateCol) {
    A = Ordering::IntOrderTest::makeColumnIMatrix(maxDim,false);
  }
  else {
    A = Ordering::IntOrderTest::makeRowIMatrix(maxDim,FALSE);
  }
  B = A.slice(2, numElem, 0, stride);
  if (!(B._not_nil() && B.dimen() == 2)) {
    res = false;
  }
  for(ind[1] = newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) !=
           sidlArrayAddr2(A._get_ior(), ind[0], ind[1]))) {
        res = false;
      }
    }
  }

  ind[0] = ind[1] = 1;
  newIndex[0] = newIndex[1] = 0;
  B = A.slice(2, numElem, ind, stride, newIndex);
  if (!(B._not_nil() && B.dimen() == 2)) {
    res = false;
  }
  for(newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) !=
           sidlArrayAddr2(A._get_ior(), ind[0], ind[1]))) {
        res = FALSE;
      }
    }
  }

  ind[0] = ind[1] = 1;
  newIndex[1] = newIndex[0] = 1;
  B= A.slice(2, numElem, ind, stride, newIndex);
  if (!(B._not_nil() && B.dimen() == 2)) {
    res = false;
  }
  for(newIndex[1] = 1; newIndex[1] <= halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 1; newIndex[0] <= halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) != 
           sidlArrayAddr2(A._get_ior(), ind[0], ind[1]))){
        res = false;
      }
    }
  }

  numElem[0] = 0;
  numElem[1] = maxDim;
  B = A.slice(1, numElem);
  if (!(B._not_nil() && B.dimen() == 1)) {
    res = false;
  }
  ind[0] = newIndex[0] = 0;
  for(ind[1] = newIndex[1] = 0; newIndex[1] < maxDim; 
      ++newIndex[1], ++ind[1]) {
    if (sidlArrayAddr1(B._get_ior(), newIndex[1]) != 
        sidlArrayAddr2(A._get_ior(), ind[0], ind[1])) {
      res = false;
    }
  }
  
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 8;
  newIndex[0] = newIndex[1] = 0;
  B = A.slice(1, numElem, ind, NULL, newIndex);
  if (!(B._not_nil() && (B.dimen() == 1))) {
    res = false;
  }
  for(ind[0] = newIndex[0] = 0; newIndex[0] < maxDim; 
      ++newIndex[0], ++ind[0]) {
    if (sidlArrayAddr1(B._get_ior(), newIndex[0]) != 
        sidlArrayAddr2(A._get_ior(), ind[0], ind[1])) {
      res = false;
    }
  }
  
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 0;
  B = A.slice(1, numElem, ind);
  if (!(B._not_nil() && (B.dimen() == 1))) {
    res = false;
  }
  if (!(Ordering::IntOrderTest::isIMatrixOne(B) &&
        Ordering::IntOrderTest::isColumnIMatrixOne(B) &&
        Ordering::IntOrderTest::isRowIMatrixOne(B))) {
    res = false;
  }
        
  
  if (B._not_nil()) B.deleteRef();
  if (A._not_nil()) A.deleteRef();
  return res;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking)
#line 551 "Ordering_IntOrderTest_Impl.cc"
}


// user-defined non-static methods: (none)

#line 515 "../../../../babel/regression/ordering/libCxx/Ordering_IntOrderTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._misc)
#line 561 "Ordering_IntOrderTest_Impl.cc"

