/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.ImplModule;
import gov.llnl.babel.backend.fortran.ImplSource;
import gov.llnl.babel.backend.fortran.SkelSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateServer
implements CodeGenerator {
    private void generateImplSource(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 12) {
            Class cls = (Class)symbol;
            PrintWriter pw = null;
            try {
                String f = Fortran.getImplFile(id);
                CodeSplicer splicer = FileManager.getInstance().getCodeSplicer(id, type, f);
                pw = FileManager.getInstance().createFile(id, type, "IMPLSRCS", f);
                LanguageWriterForFortran writer = new LanguageWriterForFortran(pw);
                ImplSource.generateCode(cls, writer, splicer);
            }
            catch (IOException ex) {
                throw new CodeGenerationException(ex.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new CodeGenerationException("NoSuchAlgorithmException: " + nsae.getMessage());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private void generateImplModule(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 12 && Fortran.isFortran90()) {
            Class cls = (Class)symbol;
            PrintWriter pw = null;
            try {
                String f = Fortran.getImplModuleFile(id);
                CodeSplicer splicer = FileManager.getInstance().getCodeSplicer(id, type, f);
                pw = FileManager.getInstance().createFile(id, type, "IMPLMODULESRCS", f);
                LanguageWriterForFortran writer = new LanguageWriterForFortran(pw);
                ImplModule.generateCode(cls, writer, splicer);
            }
            catch (IOException ex) {
                throw new CodeGenerationException(ex.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new CodeGenerationException("NoSuchAlgorithmException: " + nsae.getMessage());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private void generateSkelSource(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 12) {
            PrintWriter pw = null;
            try {
                String f = Fortran.getSkelFile(id);
                pw = FileManager.getInstance().createFile(id, type, "SKELSRCS", f);
                LanguageWriterForC writer = new LanguageWriterForC(pw);
                SkelSource.generateCode((Class)symbol, writer);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new CodeGenerationException("NoSuchAlgorithmException: " + nsae.getMessage());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator i = symbols.iterator();
        SymbolTable table = SymbolTable.getInstance();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Symbol symbol = table.lookupSymbol(id);
            this.generateSkelSource(symbol);
            this.generateImplSource(symbol);
            this.generateImplModule(symbol);
        }
    }

    public String getType() {
        return "skel";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("f77");
        result.add("f77_31");
        result.add("f90");
        return result;
    }
}

