/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.download;

import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;

public interface Download {
    public static final int ST_WAITING = 1;
    public static final int ST_PREPARING = 2;
    public static final int ST_READY = 3;
    public static final int ST_DOWNLOADING = 4;
    public static final int ST_SEEDING = 5;
    public static final int ST_STOPPING = 6;
    public static final int ST_STOPPED = 7;
    public static final int ST_ERROR = 8;
    public static final int ST_QUEUED = 9;
    public static final String[] ST_NAMES = new String[]{"", "Waiting", "Preparing", "Ready", "Downloading", "Seeding", "Stopping", "Stopped", "Error", "Queued"};
    public static final int PR_HIGH_PRIORITY = 1;
    public static final int PR_LOW_PRIORITY = 2;

    public int getState();

    public String getErrorStateDetails();

    public int getIndex();

    public Torrent getTorrent();

    public void initialize() throws DownloadException;

    public void start() throws DownloadException;

    public void stop() throws DownloadException;

    public void stopAndQueue() throws DownloadException;

    public void restart() throws DownloadException;

    public boolean isStartStopLocked();

    public boolean isForceStart();

    public void setForceStart(boolean var1);

    public int getPriority();

    public void setPriority(int var1);

    public boolean isPriorityLocked();

    public String getName();

    public String getTorrentFileName();

    public String getAttribute(TorrentAttribute var1);

    public void setAttribute(TorrentAttribute var1, String var2);

    public String getCategoryName();

    public void setCategory(String var1);

    public void remove() throws DownloadException, DownloadRemovalVetoException;

    public int getPosition();

    public long getCreationTime();

    public void setPosition(int var1);

    public void moveUp();

    public void moveDown();

    public boolean canBeRemoved() throws DownloadRemovalVetoException;

    public DownloadAnnounceResult getLastAnnounceResult();

    public DownloadScrapeResult getLastScrapeResult();

    public DownloadStats getStats();

    public boolean isPersistent();

    public void setMaximumDownloadKBPerSecond(int var1);

    public int getMaximumDownloadKBPerSecond();

    public int getUploadRateLimitBytesPerSecond();

    public void setUploadRateLimitBytesPerSecond(int var1);

    public boolean isComplete();

    public String getSavePath();

    public PeerManager getPeerManager();

    public void requestTrackerAnnounce();

    public void addListener(DownloadListener var1);

    public void removeListener(DownloadListener var1);

    public void addTrackerListener(DownloadTrackerListener var1);

    public void removeTrackerListener(DownloadTrackerListener var1);

    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener var1);

    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener var1);

    public void addPeerListener(DownloadPeerListener var1);

    public void removePeerListener(DownloadPeerListener var1);

    public void addPropertyListener(DownloadPropertyListener var1);

    public void removePropertyListener(DownloadPropertyListener var1);

    public byte[] getDownloadPeerId();
}

