/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class Debug {
    private static AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("debug");

    public static void out(String _debug_message) {
        Debug.out(_debug_message, null);
    }

    public static void out(Throwable _exception) {
        Debug.out("", _exception);
    }

    public static void outNoStack(String str) {
        Debug.outNoStack(str, false);
    }

    public static void outNoStack(String str, boolean stderr) {
        diag_logger.logAndOut("DEBUG::" + new Date(SystemTime.getCurrentTime()).toString(), stderr);
        diag_logger.logAndOut("  " + str, stderr);
    }

    /*
     * Unable to fully structure code
     */
    public static void out(String _debug_msg, Throwable _exception) {
        header = "DEBUG::";
        header = String.valueOf(header) + new Date(SystemTime.getCurrentTime()).toString() + "::";
        trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            st = e.getStackTrace();
            first_line = st[2];
            className = String.valueOf(first_line.getClassName()) + "::";
            methodName = String.valueOf(first_line.getMethodName()) + "::";
            lineNumber = first_line.getLineNumber();
            i = 3;
            ** while (i < st.length)
        }
lbl-1000:
        // 1 sources

        {
            trace_trace_tail = trace_trace_tail == null ? "" : String.valueOf(trace_trace_tail) + ",";
            cn = st[i].getClassName();
            cn = cn.substring(cn.lastIndexOf(".") + 1);
            trace_trace_tail = String.valueOf(trace_trace_tail) + cn + "::" + st[i].getMethodName() + "::" + st[i].getLineNumber();
            ++i;
            continue;
        }
lbl20:
        // 1 sources

        Debug.diag_logger.logAndOut(String.valueOf(header) + className + methodName + lineNumber + ":");
        if (_debug_msg.length() > 0) {
            Debug.diag_logger.logAndOut("  " + _debug_msg);
        }
        if (trace_trace_tail != null) {
            Debug.diag_logger.logAndOut("    " + trace_trace_tail);
        }
        if (_exception != null) {
            Debug.diag_logger.logAndOut(_exception);
        }
    }

    public static String getLastCaller() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            if (st.length > 2) {
                return st[2].toString();
            }
            if (st.length > 1) {
                return st[1].toString();
            }
            return "??";
        }
    }

    public static void outStackTrace() {
        Debug.outStackTrace(1);
    }

    /*
     * Unable to fully structure code
     */
    public static void outStackTrace(int endNumToSkip) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            st = e.getStackTrace();
            i = 1;
            ** while (i < st.length - endNumToSkip)
        }
lbl-1000:
        // 1 sources

        {
            if (st[i].getMethodName() != "outStackTrace") {
                Debug.diag_logger.logAndOut(st[i].toString());
            }
            ++i;
            continue;
        }
lbl11:
        // 1 sources

    }

    public static void killAWTThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.killAWTThreads(threadGroup);
    }

    /*
     * Unable to fully structure code
     */
    public static String getCompressedStackTrace(int frames_to_skip) {
        trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            st = e.getStackTrace();
            i = frames_to_skip;
            ** while (i < st.length)
        }
lbl-1000:
        // 1 sources

        {
            trace_trace_tail = trace_trace_tail == null ? "" : String.valueOf(trace_trace_tail) + ",";
            cn = st[i].getClassName();
            cn = cn.substring(cn.lastIndexOf(".") + 1);
            trace_trace_tail = String.valueOf(trace_trace_tail) + cn + "::" + st[i].getMethodName() + "::" + st[i].getLineNumber();
            ++i;
            continue;
        }
lbl14:
        // 1 sources

        return trace_trace_tail;
    }

    public static void killAWTThreads(ThreadGroup threadGroup) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        int i = 0;
        while (i < threadList.length) {
            String name;
            Thread t = threadList[i];
            if (t != null && (name = t.getName()).startsWith("AWT")) {
                Debug.out("Interrupting thread '".concat(t.toString()).concat("'"));
                t.interrupt();
            }
            ++i;
        }
        if (threadGroup.getParent() != null) {
            Debug.killAWTThreads(threadGroup.getParent());
        }
    }

    public static void dumpThreads(String name) {
        Debug.out(String.valueOf(name) + ":");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.dumpThreads(threadGroup, "\t");
    }

    public static void dumpThreads(ThreadGroup threadGroup, String indent) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        int i = 0;
        while (i < threadList.length) {
            Thread t = threadList[i];
            if (t != null) {
                Debug.out(indent.concat("active thread = ").concat(t.toString()).concat(", daemon = ").concat(String.valueOf(t.isDaemon())));
            }
            ++i;
        }
        if (threadGroup.getParent() != null) {
            Debug.dumpThreads(threadGroup.getParent(), String.valueOf(indent) + "\t");
        }
    }

    public static void dumpThreadsLoop(final String name) {
        new AEThread("Thread Dumper"){

            public void runSupport() {
                while (true) {
                    Debug.dumpThreads(name);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void dumpSystemProperties() {
        Debug.out("System Properties:");
        Properties props = System.getProperties();
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Debug.out("\t".concat(name).concat(" = '").concat(props.get(name).toString()).concat("'"));
        }
    }

    public static String getNestedExceptionMessage(Throwable e) {
        String last_message = null;
        while (true) {
            if (e.getMessage() != null) {
                last_message = String.valueOf(e.getMessage()) + (last_message == null ? "" : ", " + last_message);
            }
            if (e.getCause() == null) break;
            e = e.getCause();
        }
        if (last_message == null) {
            last_message = e.getClass().getName();
            int pos = last_message.lastIndexOf(".");
            last_message = last_message.substring(pos + 1);
        }
        return last_message;
    }

    public static void printStackTrace(Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            Debug.outNoStack(baos.toString(), true);
        }
        catch (Throwable ignore) {
            e.printStackTrace();
        }
    }
}

