/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.ILoggerListener;
import org.gudy.azureus2.core3.logging.LGAlertListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;

public class LGLoggerImpl {
    public static final String LOG_FILE_NAME = "az.log";
    public static final String BAK_FILE_NAME = "az.log.bak";
    public static final String NL = "\r\n";
    public static final int[] components;
    private static boolean initialised;
    private static List log_history;
    private static ILoggerListener listener;
    private static List alert_listeners;
    private static List alert_history;
    private static boolean log_to_file;
    private static boolean log_to_stdout;
    private static PrintStream old_system_out;
    private static PrintStream old_system_err;
    private static PrintStream out_redirector;
    private static PrintStream err_redirector;
    private static String log_dir;
    private static int log_file_max;
    private static int[] log_types;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        components = nArray;
        initialised = false;
        log_history = new ArrayList();
        alert_listeners = new ArrayList();
        alert_history = new ArrayList();
        log_to_file = false;
        log_to_stdout = System.getProperty("azureus.log.stdout") != null;
        old_system_out = null;
        old_system_err = null;
        log_dir = "";
        log_file_max = 1;
        log_types = new int[components.length];
    }

    public static synchronized void initialise() {
        if (!initialised) {
            boolean overrideLog;
            initialised = true;
            boolean bl = overrideLog = System.getProperty("azureus.overridelog") != null;
            if (!overrideLog) {
                COConfigurationManager.addListener(new COConfigurationListener(){

                    public void configurationSaved() {
                        LGLoggerImpl.checkLoggingConfig();
                    }
                });
            }
            LGLoggerImpl.checkLoggingConfig();
            LGLoggerImpl.doRedirects();
            LGLogger.log("**** Logging starts: 2.2.0.2 ****");
            LGLogger.log("java.home=" + System.getProperty("java.home"));
            LGLogger.log("java.version=" + System.getProperty("java.version"));
            LGLogger.log("os=" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/" + System.getProperty("os.version"));
            LGLogger.log("user.dir=" + System.getProperty("user.dir"));
            LGLogger.log("user.home=" + System.getProperty("user.home"));
            if (log_to_file) {
                int i = 0;
                while (i < log_history.size()) {
                    Object[] entry2 = (Object[])log_history.get(i);
                    LGLoggerImpl.log((Integer)entry2[0], (Integer)entry2[1], (Integer)entry2[2], (String)entry2[3]);
                    ++i;
                }
            }
            log_history.clear();
        }
    }

    public static void checkRedirection() {
        boolean overrideLog;
        boolean bl = overrideLog = System.getProperty("azureus.overridelog") != null;
        if (!overrideLog) {
            LGLoggerImpl.doRedirects();
        }
    }

    protected static void doRedirects() {
        try {
            if (System.out != out_redirector) {
                if (old_system_out == null) {
                    old_system_out = System.out;
                }
                out_redirector = new PrintStream(new redirectorOutputStream(old_system_out));
                System.setOut(out_redirector);
            }
            if (System.err != err_redirector) {
                if (old_system_err == null) {
                    old_system_err = System.err;
                }
                err_redirector = new PrintStream(new redirectorOutputStream(old_system_err));
                System.setErr(err_redirector);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static void checkLoggingConfig() {
        boolean overrideLog;
        boolean bl = overrideLog = System.getProperty("azureus.overridelog") != null;
        if (overrideLog) {
            log_to_file = true;
            log_dir = ".";
            log_file_max = 2;
            int i = 0;
            while (i < log_types.length) {
                LGLoggerImpl.log_types[i] = 0;
                int j = 0;
                while (j <= 3) {
                    int n = i;
                    log_types[n] = log_types[n] | 1 << j;
                    ++j;
                }
                ++i;
            }
        } else {
            log_to_file = COConfigurationManager.getBooleanParameter("Logging Enable", false);
            log_dir = COConfigurationManager.getStringParameter("Logging Dir", "");
            log_file_max = COConfigurationManager.getIntParameter("Logging Max Size");
            int i = 0;
            while (i < log_types.length) {
                LGLoggerImpl.log_types[i] = 0;
                int j = 0;
                while (j <= 3) {
                    int n = i;
                    log_types[n] = log_types[n] | (COConfigurationManager.getBooleanParameter("bLog" + components[i] + "-" + j) ? 1 << j : 0);
                    ++j;
                }
                ++i;
            }
        }
    }

    public static synchronized void log(int componentId, int event, int color, String text) {
        if (initialised) {
            if (log_to_file) {
                int logTypeIndex = 0;
                int i = 0;
                while (i < components.length) {
                    if (components[i] == componentId) {
                        logTypeIndex = i;
                        break;
                    }
                    ++i;
                }
                if ((log_types[logTypeIndex] & 1 << color) != 0) {
                    LGLoggerImpl.logToFile("{" + componentId + ":" + event + ":" + color + "}  " + text + NL);
                }
            }
            if (listener != null) {
                listener.log(componentId, event, color, text);
            }
        } else {
            log_history.add(new Object[]{new Integer(componentId), new Integer(event), new Integer(color), text});
        }
    }

    public static boolean isLoggingOn() {
        return listener != null || log_to_file;
    }

    public static synchronized void setListener(ILoggerListener _listener) {
        listener = _listener;
    }

    public static synchronized void removeListener() {
        listener = null;
    }

    public static void logAlert(int type, String message, boolean repeatable) {
        LGLogger.log("Alert:" + type + ":" + message);
        alert_history.add(new Object[]{new Integer(type), message, new Boolean(repeatable)});
        if (alert_history.size() > 256) {
            alert_history.remove(0);
        }
        int i = 0;
        while (i < alert_listeners.size()) {
            try {
                ((LGAlertListener)alert_listeners.get(i)).alertRaised(type, message, repeatable);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public static void logAlert(String message, Throwable e, boolean repeatable) {
        LGLogger.log("Alert:" + message, e);
        alert_history.add(new Object[]{message, e, new Boolean(repeatable)});
        if (alert_history.size() > 256) {
            alert_history.remove(0);
        }
        int i = 0;
        while (i < alert_listeners.size()) {
            try {
                ((LGAlertListener)alert_listeners.get(i)).alertRaised(message, e, repeatable);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public static void addAlertListener(LGAlertListener l) {
        alert_listeners.add(l);
        int i = 0;
        while (i < alert_history.size()) {
            Object[] entry2 = (Object[])alert_history.get(i);
            boolean repeatable = (Boolean)entry2[2];
            if (entry2[0] instanceof Integer) {
                l.alertRaised((Integer)entry2[0], (String)entry2[1], repeatable);
            } else {
                l.alertRaised((String)entry2[0], (Throwable)entry2[1], repeatable);
            }
            ++i;
        }
    }

    public static void removeAlertListener(LGAlertListener l) {
        alert_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void logToFile(String str) {
        if (!log_to_file) return;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.core3.logging.LGLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Calendar now = GregorianCalendar.getInstance();
            String timeStamp = "[".concat(String.valueOf(now.get(11))).concat(":").concat(LGLoggerImpl.format(now.get(12))).concat(":").concat(LGLoggerImpl.format(now.get(13))).concat("]  ");
            str = timeStamp.concat(str);
            PrintWriter pw = null;
            File file_name = new File(log_dir.concat(File.separator).concat(LOG_FILE_NAME));
            try {
                try {
                    pw = new PrintWriter(new FileWriter(file_name, true));
                    pw.print(str);
                    if (!log_to_stdout) return;
                    old_system_out.println(str);
                }
                catch (Throwable throwable) {}
            }
            finally {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable max_bytes) {}
                    long max_bytes = log_file_max * 1024 * 1024 / 2;
                    if (file_name.length() > max_bytes) {
                        File back_name = new File(log_dir.concat(File.separator).concat(BAK_FILE_NAME));
                        if (!back_name.exists() || back_name.delete()) {
                            if (!file_name.renameTo(back_name)) {
                                file_name.delete();
                            }
                        } else {
                            file_name.delete();
                        }
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String format(int n) {
        if (n < 10) {
            return "0".concat(String.valueOf(n));
        }
        return String.valueOf(n);
    }

    protected static class redirectorOutputStream
    extends OutputStream {
        protected PrintStream ps;
        protected StringBuffer buffer = new StringBuffer(1024);

        protected redirectorOutputStream(PrintStream _ps) {
            this.ps = _ps;
        }

        public void write(int data) {
            char c = (char)data;
            this.buffer.append(c);
            if (c == '\n') {
                this.ps.print(this.buffer);
                LGLoggerImpl.logToFile(this.buffer.toString());
                this.buffer.setLength(0);
            }
        }

        public void write(byte[] b, int off, int len) {
            int i = off;
            while (i < off + len) {
                int d = b[i];
                if (d < 0) {
                    d += 256;
                }
                this.write(d);
                ++i;
            }
        }
    }
}

