/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTPiece;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingBTPieceMessageHandler {
    private static final int MIN_READ_AHEAD = 3;
    private final OutgoingMessageQueue outgoing_message_queue;
    private final DiskManager disk_manager;
    private final LinkedList requests = new LinkedList();
    private final List loading_messages = new ArrayList();
    private final Map queued_messages = new HashMap();
    private int num_messages_loading = 0;
    private int num_messages_in_queue = 0;
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    data.returnToPool();
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
                OutgoingBTPieceMessageHandler outgoingBTPieceMessageHandler = OutgoingBTPieceMessageHandler.this;
                outgoingBTPieceMessageHandler.num_messages_loading = outgoingBTPieceMessageHandler.num_messages_loading - 1;
                BTPiece msg = new BTPiece(request2.getPieceNumber(), request2.getOffset(), data);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(msg, request2);
                OutgoingBTPieceMessageHandler outgoingBTPieceMessageHandler2 = OutgoingBTPieceMessageHandler.this;
                outgoingBTPieceMessageHandler2.num_messages_in_queue = outgoingBTPieceMessageHandler2.num_messages_in_queue + 1;
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(msg, true);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public void messageSent(ProtocolMessage message) {
            if (message.getType() == 7) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                    OutgoingBTPieceMessageHandler outgoingBTPieceMessageHandler = OutgoingBTPieceMessageHandler.this;
                    outgoingBTPieceMessageHandler.num_messages_in_queue = outgoingBTPieceMessageHandler.num_messages_in_queue - 1;
                    OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
            }
        }

        public void messageAdded(ProtocolMessage message) {
        }

        public void messageRemoved(ProtocolMessage message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    public OutgoingBTPieceMessageHandler(DiskManager disk_manager, OutgoingMessageQueue outgoing_message_q) {
        this.disk_manager = disk_manager;
        this.outgoing_message_queue = outgoing_message_q;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    public void addPieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest dmr = this.disk_manager.createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            this.requests.addLast(dmr);
            this.doReadAheadLoads();
        }
        finally {
            this.lock_mon.exit();
        }
    }

    public void removePieceRequest(int piece_number, int piece_offset, int length) {
        DiskManagerReadRequest dmr = this.disk_manager.createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            if (this.requests.contains(dmr)) {
                this.requests.remove(dmr);
                this.lock_mon.exit();
                return;
            }
            if (this.loading_messages.contains(dmr)) {
                this.loading_messages.remove(dmr);
                --this.num_messages_loading;
                this.lock_mon.exit();
                return;
            }
            Iterator i = this.queued_messages.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry2 = i.next();
                if (!entry2.getValue().equals(dmr)) continue;
                BTPiece msg = (BTPiece)entry2.getKey();
                if (this.outgoing_message_queue.removeMessage(msg, true)) {
                    i.remove();
                    --this.num_messages_in_queue;
                }
                this.lock_mon.exit();
                return;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void removeAllPieceRequests() {
        try {
            this.lock_mon.enter();
            this.requests.clear();
            this.loading_messages.clear();
            this.num_messages_loading = 0;
            Iterator i = this.queued_messages.keySet().iterator();
            while (i.hasNext()) {
                BTPiece msg = (BTPiece)i.next();
                if (!this.outgoing_message_queue.removeMessage(msg, true)) continue;
                i.remove();
                --this.num_messages_in_queue;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void destroy() {
        try {
            this.lock_mon.enter();
            this.requests.clear();
            this.loading_messages.clear();
            this.num_messages_loading = 0;
            this.destroyed = true;
        }
        finally {
            this.lock_mon.exit();
        }
    }

    private void doReadAheadLoads() {
        while (this.num_messages_loading + this.num_messages_in_queue < 3 && !this.requests.isEmpty() && !this.destroyed) {
            DiskManagerReadRequest dmr = (DiskManagerReadRequest)this.requests.removeFirst();
            this.loading_messages.add(dmr);
            this.disk_manager.enqueueReadRequest(dmr, this.read_req_listener);
            ++this.num_messages_loading;
        }
    }
}

