/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messages.bittorrent;

import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTProtocolMessage;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class BTHandshake
implements BTProtocolMessage {
    public static final String PROTOCOL = "BitTorrent protocol";
    public static final byte[] RESERVED = new byte[8];
    private final DirectByteBuffer buffer;
    private final byte[] data_hash;
    private final byte[] peer_id;
    private final int total_byte_size;

    public BTHandshake(byte[] data_hash, byte[] peer_id) {
        this.data_hash = data_hash;
        this.peer_id = peer_id;
        this.buffer = new DirectByteBuffer(ByteBuffer.allocate(68));
        this.buffer.put((byte)6, (byte)PROTOCOL.length());
        this.buffer.put((byte)6, PROTOCOL.getBytes());
        this.buffer.put((byte)6, RESERVED);
        this.buffer.put((byte)6, data_hash);
        this.buffer.put((byte)6, peer_id);
        this.buffer.position((byte)6, 0);
        this.buffer.limit((byte)6, 68);
        this.total_byte_size = this.buffer.limit((byte)6);
    }

    public int getType() {
        return -1;
    }

    public DirectByteBuffer getPayload() {
        return this.buffer;
    }

    public int getTotalMessageByteSize() {
        return this.total_byte_size;
    }

    public String getDescription() {
        return "Handshake of DataID: " + ByteFormatter.nicePrint(this.data_hash, true) + " PeerID: " + PeerClassifier.getPrintablePeerID(this.peer_id);
    }

    public int getPriority() {
        return 2;
    }

    public boolean isNoDelay() {
        return true;
    }

    public boolean isDataMessage() {
        return false;
    }

    public void destroy() {
    }

    public int[] typesToRemove() {
        return null;
    }
}

