/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualServerChannelSelector {
    private ServerSocketChannel server_channel = null;
    private final InetSocketAddress bind_address;
    private final SelectListener listener;
    private boolean running = false;

    public VirtualServerChannelSelector(InetSocketAddress bind_address, SelectListener listener) {
        this.bind_address = bind_address;
        this.listener = listener;
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                this.server_channel = ServerSocketChannel.open();
                this.server_channel.socket().setReuseAddress(true);
                this.server_channel.socket().bind(this.bind_address, 100);
                AEThread accept_thread = new AEThread("VServerSelector:port" + this.bind_address.getPort()){

                    public void runSupport() {
                        VirtualServerChannelSelector.this.running = true;
                        VirtualServerChannelSelector.this.accept_loop();
                    }
                };
                accept_thread.setDaemon(true);
                accept_thread.start();
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.server_channel != null) {
            try {
                this.server_channel.close();
                this.server_channel = null;
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    private void accept_loop() {
        while (this.running) {
            try {
                SocketChannel client_channel = this.server_channel.accept();
                client_channel.configureBlocking(false);
                this.listener.newConnectionAccepted(client_channel);
            }
            catch (Throwable t) {
                Debug.out(t);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public interface SelectListener {
        public void newConnectionAccepted(SocketChannel var1);
    }
}

