/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.system;

import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.context.Context;

/**
 * The Container is an interface used to mark the Containers in your system.  It
 * exposes a protected getComponentManager() method so that the Container's
 * Manager can expose that to the instantiating class.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.5 $ $Date: 2002/01/25 20:15:11 $
 */
public interface Container
{
    String CONTEXT_CLASSLOADER = "container.classloader";
    String CONTEXT_DIRECTORY   = "container.rootDir";
    String WORK_DIRECTORY      = "container.workDir";
    String LOGGER_MANAGER      = "container.logManager";
    String COMMAND_QUEUE       = "container.commandQueue";
    String POOL_MANAGER        = "container.poolManager";
    String ROLE_MANAGER        = "container.roleManager";
}

