/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collections;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.IHasSourceLocation;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public abstract class Advice
extends ShadowMunger {
    protected AjAttribute.AdviceAttribute attribute;
    protected AdviceKind kind;
    protected Member signature;
    protected ResolvedTypeX concreteAspect;
    protected List innerCflowEntries = Collections.EMPTY_LIST;
    protected int nFreeVars;
    protected TypePattern exceptionType;
    private volatile int hashCode = 0;
    public static final int ExtraArgument = 1;
    public static final int ThisJoinPoint = 2;
    public static final int ThisJoinPointStaticPart = 4;
    public static final int ThisEnclosingJoinPointStaticPart = 8;
    public static final int ParameterMask = 15;
    public static final int CanInline = 64;

    public static Advice makeCflowEntry(World world, Pointcut entry, boolean isBelow, Member stackField, int nFreeVars, List innerCflowEntries, ResolvedTypeX inAspect) {
        Advice ret = world.concreteAdvice(isBelow ? AdviceKind.CflowBelowEntry : AdviceKind.CflowEntry, entry, stackField, 0, entry);
        ret.innerCflowEntries = innerCflowEntries;
        ret.nFreeVars = nFreeVars;
        ret.concreteAspect = inAspect;
        return ret;
    }

    public static Advice makePerCflowEntry(World world, Pointcut entry, boolean isBelow, Member stackField, ResolvedTypeX inAspect, List innerCflowEntries) {
        Advice ret = world.concreteAdvice(isBelow ? AdviceKind.PerCflowBelowEntry : AdviceKind.PerCflowEntry, entry, stackField, 0, entry);
        ret.innerCflowEntries = innerCflowEntries;
        ret.concreteAspect = inAspect;
        return ret;
    }

    public static Advice makePerObjectEntry(World world, Pointcut entry, boolean isThis, ResolvedTypeX inAspect) {
        Advice ret = world.concreteAdvice(isThis ? AdviceKind.PerThisEntry : AdviceKind.PerTargetEntry, entry, null, 0, entry);
        ret.concreteAspect = inAspect;
        return ret;
    }

    public static Advice makePerTypeWithinEntry(World world, Pointcut p, ResolvedTypeX inAspect) {
        Advice ret = world.concreteAdvice(AdviceKind.PerTypeWithinEntry, p, null, 0, p);
        ret.concreteAspect = inAspect;
        return ret;
    }

    public static Advice makeSoftener(World world, Pointcut entry, TypePattern exceptionType, ResolvedTypeX inAspect, IHasSourceLocation loc) {
        Advice ret = world.concreteAdvice(AdviceKind.Softener, entry, null, 0, loc);
        ret.exceptionType = exceptionType;
        ret.concreteAspect = inAspect;
        return ret;
    }

    public Advice(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        super(pointcut, attribute.getStart(), attribute.getEnd(), attribute.getSourceContext());
        this.attribute = attribute;
        this.kind = attribute.getKind();
        this.signature = signature;
    }

    public boolean match(Shadow shadow, World world) {
        if (super.match(shadow, world)) {
            if (shadow.getKind() == Shadow.ExceptionHandler && (this.kind.isAfter() || this.kind == AdviceKind.Around)) {
                world.showMessage(IMessage.WARNING, WeaverMessages.format("onlyBeforeOnHandler"), this.getSourceLocation(), shadow.getSourceLocation());
                return false;
            }
            if (this.hasExtraParameter() && this.kind == AdviceKind.AfterReturning) {
                return this.getExtraParameterType().isConvertableFrom(shadow.getReturnType(), world);
            }
            if (this.kind == AdviceKind.PerTargetEntry) {
                return shadow.hasTarget();
            }
            if (this.kind == AdviceKind.PerThisEntry) {
                return shadow.hasThis();
            }
            if (this.kind == AdviceKind.Around) {
                if (shadow.getKind() == Shadow.PreInitialization) {
                    world.showMessage(IMessage.ERROR, WeaverMessages.format("aroundOnPreInit"), this.getSourceLocation(), shadow.getSourceLocation());
                    return false;
                }
                if (shadow.getKind() == Shadow.Initialization) {
                    world.showMessage(IMessage.ERROR, WeaverMessages.format("aroundOnInit"), this.getSourceLocation(), shadow.getSourceLocation());
                    return false;
                }
                if (shadow.getKind() == Shadow.StaticInitialization && shadow.getEnclosingType().isInterface(world)) {
                    world.showMessage(IMessage.ERROR, WeaverMessages.format("aroundOnInterfaceStaticInit", shadow.getEnclosingType().getName()), this.getSourceLocation(), shadow.getSourceLocation());
                    return false;
                }
                if (this.getSignature().getReturnType() == ResolvedTypeX.VOID) {
                    if (shadow.getReturnType() != ResolvedTypeX.VOID) {
                        world.showMessage(IMessage.ERROR, WeaverMessages.format("nonVoidReturn", shadow), this.getSourceLocation(), shadow.getSourceLocation());
                        return false;
                    }
                } else {
                    if (this.getSignature().getReturnType().equals(TypeX.OBJECT)) {
                        return true;
                    }
                    if (!shadow.getReturnType().isAssignableFrom(this.getSignature().getReturnType(), world)) {
                        world.showMessage(IMessage.ERROR, WeaverMessages.format("incompatibleReturnType", shadow), this.getSourceLocation(), shadow.getSourceLocation());
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public AdviceKind getKind() {
        return this.kind;
    }

    public Member getSignature() {
        return this.signature;
    }

    public boolean hasExtraParameter() {
        return (this.getExtraParameterFlags() & 1) != 0;
    }

    protected int getExtraParameterFlags() {
        return this.attribute.getExtraParameterFlags();
    }

    protected int getExtraParameterCount() {
        return Advice.countOnes(this.getExtraParameterFlags() & 0xF);
    }

    public static int countOnes(int bits) {
        int ret = 0;
        while (bits != 0) {
            if ((bits & 1) != 0) {
                ++ret;
            }
            bits >>= 1;
        }
        return ret;
    }

    public int getBaseParameterCount() {
        return this.getSignature().getParameterTypes().length - this.getExtraParameterCount();
    }

    public String[] getBaseParameterNames(World world) {
        String[] allNames = this.getSignature().getParameterNames(world);
        int extras = this.getExtraParameterCount();
        if (extras == 0) {
            return allNames;
        }
        String[] result = new String[this.getBaseParameterCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = allNames[i];
        }
        return result;
    }

    public TypeX getExtraParameterType() {
        if (!this.hasExtraParameter()) {
            return ResolvedTypeX.MISSING;
        }
        return this.signature.getParameterTypes()[this.getBaseParameterCount()];
    }

    public TypeX getDeclaringAspect() {
        return this.signature.getDeclaringType();
    }

    protected String extraParametersToString() {
        if (this.getExtraParameterFlags() == 0) {
            return "";
        }
        return "(extraFlags: " + this.getExtraParameterFlags() + ")";
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public ShadowMunger concretize(ResolvedTypeX fromType, World world, PerClause clause) {
        Pointcut p = this.pointcut.concretize(fromType, this.signature.getArity(), this);
        if (clause != null) {
            Pointcut oldP = p;
            p = new AndPointcut(clause, p);
            p.copyLocationFrom(oldP);
            p.state = Pointcut.CONCRETE;
            p.m_ignoreUnboundBindingForNames = oldP.m_ignoreUnboundBindingForNames;
        }
        Advice munger = world.concreteAdvice(this.attribute, p, this.signature);
        munger.concreteAspect = fromType;
        return munger;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.getKind()).append(this.extraParametersToString());
        sb.append(": ").append(this.pointcut).append("->").append(this.signature).append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Advice)) {
            return false;
        }
        Advice o = (Advice)other;
        return o.attribute.equals(this.attribute) && o.pointcut.equals(this.pointcut) && o.signature.equals(this.signature);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.kind.hashCode();
            result = 37 * result + this.pointcut.hashCode();
            if (this.signature != null) {
                result = 37 * result + this.signature.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public void setLexicalPosition(int lexicalPosition) {
        this.start = lexicalPosition;
    }

    public ResolvedTypeX getConcreteAspect() {
        return this.concreteAspect;
    }
}

