/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathJar
extends ClasspathLocation {
    private static int maxOpenArchives = 1000;
    private static final int MAXOPEN_DEFAULT = 1000;
    private static List openArchives = new ArrayList();
    private File file;
    private ZipFile zipFile;
    private boolean closeZipFileAtEnd;
    private Hashtable packageCache;

    static {
        String openarchivesString = ClasspathJar.getSystemPropertyWithoutSecurityException("org.aspectj.weaver.openarchives", Integer.toString(1000));
        maxOpenArchives = Integer.parseInt(openarchivesString);
        if (maxOpenArchives < 20) {
            maxOpenArchives = 1000;
        }
    }

    public ClasspathJar(File file) throws IOException {
        this(file, true, null);
    }

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            this.ensureOpen();
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void initialize() throws IOException {
        this.zipFile = new ZipFile(this.file);
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put("", "");
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block2: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (this.packageCache.containsKey(packageName)) continue block2;
                this.packageCache.put(packageName, packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(qualifiedPackageName);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            this.close();
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public String normalizedPath() {
        String rawName = this.file.getPath();
        return rawName.substring(0, rawName.lastIndexOf(46));
    }

    public String getPath() {
        return this.file.getPath();
    }

    private void ensureOpen() throws IOException {
        if (this.zipFile != null) {
            return;
        }
        if (openArchives.size() >= maxOpenArchives) {
            this.closeSomeArchives(openArchives.size() / 10);
        }
        this.zipFile = new ZipFile(this.file);
        openArchives.add(this);
    }

    private void closeSomeArchives(int n) {
        int i = n - 1;
        while (i >= 0) {
            ClasspathJar zf = (ClasspathJar)openArchives.get(0);
            zf.close();
            --i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.zipFile == null) {
            return;
        }
        try {
            try {
                openArchives.remove(this);
                this.zipFile.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.zipFile = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.zipFile = null;
            return;
        }
    }

    private static String getSystemPropertyWithoutSecurityException(String aPropertyName, String aDefaultValue) {
        try {
            return System.getProperty(aPropertyName, aDefaultValue);
        }
        catch (SecurityException ex) {
            return aDefaultValue;
        }
    }
}

