/*
 * m-file-panel.c : Save-load-write menu routines
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/StringDefs.h>
#include "menu.h"
#include "appres.h"
#include "file-panel.h"

/*
 * Functions defined here:
 */
void initFilePanelMenu();
static void fileWriteModeMenuCallback();

/*
 * Data defined here:
 */
static Widget fileWriteModeMenu;
static SmeBSBObject fileWriteModeMenuItems[2];

static Boolean fileWriteModeValues [] = {
    True, False
};

/*	-	-	-	-	-	-	-	-	*/

void
initFilePanelMenu()
{
    fileWriteModeMenu = createMenu("filePanelWriteModeMenu",
				   "filePanelWriteModeMenuItem",2,
				   fileWriteModeMenuItems,
				   fileWriteModeMenuCallback);
}

/*	-	-	-	-	-	-	-	-	*/
/* Callback procedures */

/*ARGSUSED*/
static void
fileWriteModeMenuCallback(w,client_data,call_data)
Widget w;
XtPointer client_data;	/* item */
XtPointer call_data;	/* ignored */
{
    int item = (int)client_data;

    setIthItemMark(fileWriteModeMenuItems,item,
		   XtNumber(fileWriteModeMenuItems));
    appResources.fileWriteOnePerLine = fileWriteModeValues[item];
    updateFileWriteMode(appResources.fileWriteOnePerLine);
}
