/* routines call imaging routines in combine library for the countner */
#include "cdebug.h"
#include "combine.h"
#include "gdfonts.h"
#include "count.h"

#ifdef SYS_WIN32
#include "configNT.h"
#elif defined( __VMS )
#include "configVMS.h"
#else
#include "config.h"
#endif

#ifdef __VMS
#define GIF_PATH_FMT "%s%s]%s" /* Already have ] at end of _DIR macros */
#else
#define GIF_PATH_FMT "%s/%s/%s"
#endif


static char *ImagePrefix[]=
{
    "zero", "one", "two", "three", "four", "five", 
    "six", "seven", "eight", "nine",
};

/*
 *  StringImage - creates an Image from string
 *
 *  RCS:
 *      $Revision: 2.3 $
 *      $Date: 1996/05/03 02:20:22 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   09-Sep-95   first cut
 */


void StringImage(str)
char
    *str;
{
    Image
        *fimage,
        *image;

    int
        str_length;

    FrameInfo
        frame_info;
    SFontInfo
        font_info;

    str_length=(int) strlen(str);
    image=CreateBaseImage(gdFontSmall->w*str_length+10,
        gdFontSmall->h+10,0,0,0,DirectClass);

    if (image == (Image *) NULL)
    {
        (void) fprintf (stderr," Unable to create base image for string!\n");
        return;
    }
    
    font_info.do_bg=True;
    font_info.bgr=0;
    font_info.bgg=0;
    font_info.bgb=0;

    font_info.fgr=0;
    font_info.fgg=255;
    font_info.fgb=0;

    ImageString(image,gdFontSmall,5,5,str,&font_info);
    GetFrameInfo(image->columns,image->rows,&frame_info);
    fimage=FrameImage(image,&frame_info);
    if (fimage != (Image *) NULL)
    {
        DestroyAnyImageStruct(&image);
        image=fimage;
    }
    WriteGIFImage(image,(char *) NULL);
    
}
/*
** mogrify image if needed
*/
void MogrifyImage(image,digit_info,frame_info)
Image
    **image;
DigitInfo
    *digit_info;
FrameInfo
    *frame_info;
{
    Image
        *framed_image,
        *rotated_image;

    if (*image != (Image *) NULL)
    {
        if (digit_info->negate == True)
            NegateImage(*image);
            
        if (digit_info->Frame == True) 
        {
            RGB 
               color,
               matte_color;
            
            matte_color.red=frame_info->matte_color.red;
            matte_color.green=frame_info->matte_color.green;
            matte_color.blue=frame_info->matte_color.blue;

            frame_info->height=frame_info->width;
            frame_info->outer_bevel=(frame_info->width >> 2)+1;
            frame_info->inner_bevel=frame_info->outer_bevel;
            frame_info->x=frame_info->width;
            frame_info->y=frame_info->height;
            frame_info->width=(*image)->columns+(frame_info->width << 1);
            frame_info->height=(*image)->rows+(frame_info->height << 1);
            frame_info->matte_color=matte_color; 
        
            XModulate(&color,matte_color.red,matte_color.green,
                matte_color.blue, HighlightModulate);
            frame_info->highlight_color.red=color.red;
            frame_info->highlight_color.green=color.green;
            frame_info->highlight_color.blue=color.blue;

            XModulate(&color,matte_color.red,matte_color.green,
                matte_color.blue, ShadowModulate);
            frame_info->shadow_color.red=color.red;
            frame_info->shadow_color.green=color.green;
            frame_info->shadow_color.green=color.green;

            framed_image=FrameImage(*image,frame_info);
            if (framed_image != (Image *) NULL)
            {
                DestroyAnyImageStruct (image);
                framed_image->class=DirectClass;
                *image=framed_image;
            }
        }    
        
        (*image)->comments = (char *) malloc (1024*sizeof(char));
        if ((*image)->comments != (char *) NULL)
        {
            /*
            (void) sprintf((*image)->comments,"\n%s %s \n%s %s\n%s %s\n%s\n%s",
                "Count.cgi", Version, "By", Author, "URL:", Url,
                "Built:",GetTime());
            */
            (void) strcpy((*image)->comments,IMAGE_COMMENT);
        }
        

        if (digit_info->replace_color == True)
        {
            OpaqueImage(*image,
                digit_info->opaque_red,
                digit_info->opaque_green,
                digit_info->opaque_blue,
                digit_info->pen_red,
                digit_info->pen_green,
                digit_info->pen_blue);

        }

        if (digit_info->alpha == True)
        {
             AlphaImage(*image,digit_info->alpha_red,digit_info->alpha_green,
                digit_info->alpha_blue);
        }
         if (digit_info->rotate == True)
         {
            rotated_image=RotateImage(*image,digit_info->rotate_degrees);
            if (rotated_image != (Image *) NULL)
            {
                DestroyAnyImageStruct (image);
                *image=rotated_image;
            }
            else
            {
                (void) fprintf (stderr," Could not rotate %d degrees\n",
                    digit_info->rotate_degrees);
            }
         }
    }
}

Image *CombineImages(digitbuf,digit_info)
char
    *digitbuf;
DigitInfo
    *digit_info;
{
    register char
        *p;

    char
        tmpbuf[MaxTextLength];

    int
        rc=0;

    unsigned int
        bwidth,
        bheight,
        gbW,
        gbH,
        base_width,
        base_height;

    Image
        *strip_image,
        *sub_image,
        *base_image;

    int
        nsegment,
        segment;

    int
        *seg_array=(int *) NULL;

    RectangleInfo
        rinfo;
    int
        n;
 
    int
        i;
    char
        *token;

    segment=0;
    bwidth=0;
    bheight=0;
    gbW=0;
    gbH=0;
    base_width=0;
    base_height=0;
    strip_image=(Image *) NULL;


    /*
    ** if comma is requesed, commaize (my new invented word!) the
    ** digit. also it's meaningness to left pad while commizing,
    ** therefore, don't left pad with zeros as well
    */
    if ((digit_info->display_type == (unsigned int) SHOW_COUNTER) &&
        (digit_info->comma == True))
    {
        Commaize(digitbuf);
        Debug2("after commaze=%s",digitbuf,0);
    }
    /*
    ** if image strip is not used, we'll handle it as usual
    */
if (digit_info->use_strip == False)
{
    for (p=digitbuf; *p != '\0'; p++)
    {
        *tmpbuf='\0';
        if(isdigit(*p))
        {
            (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                g_sZ_ibase,digit_info->ddhead,ImagePrefix[(int)*p-'0']);
        }
        else
        {
            if (*p == ':')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"colon");
            else if ((*p == 'A') || (*p == 'a'))
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"am");
            else if ((*p == 'P') || (*p == 'p'))
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"pm");
            else if (*p == ',')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"comma");
            else
                if (*p == '-')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"dash");
        }
        rc=GetGIFsize(tmpbuf,&gbW,&gbH);
        if (rc)
        {
            PrintHeader();
            StringImage("Unable to determine digit image size!");
            exit(1);
        }
        bwidth += gbW;
        if (gbH > bheight)
            bheight=gbH;
    }
}
else
{
    /*
    ** strip is in use. First of all, we will determine the with of the
    ** base image. The segments in the strip may be of varaible widths,
    ** we'll handle it
    */
    (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                          g_sZ_ibase,digit_info->ddhead,"strip");
    strip_image=ReadImage(tmpbuf);
    if (strip_image == (Image *) NULL)
    {
        PrintHeader();
        StringImage("Unable to read strip image!");
        exit(1);
    }
    if (strip_image->comments != (char *) NULL)
    {
        rc=sscanf(strip_image->comments,"%d",&nsegment);
        Debug2("segments=%d rc=%d",nsegment,rc);
        if (rc != 1)
        {
            PrintHeader();
            StringImage("No string segment info found in GIF comment ext.!");
            exit(1);
        }

        seg_array=(int *) malloc((nsegment+2)*sizeof(int));
        if (seg_array == (int *) NULL)
        {
            PrintHeader();
            StringImage("Memory Allocation Failed for seg_array!");
            exit(1);   
        }
        p=strip_image->comments;
        i=0;
        while ((token=mystrtok(p,":")) != (char *) NULL)
        {
            p=(char *) NULL;
            if (token != (char *) NULL)
                seg_array[i]=atoi(token);
            i++;
        }
        /*
        ** the info about strip in the comment extension of the GIF image
        ** does not match. we'll abort
        ** btw, if the strip is created with my mkstrip program, the info
        ** should be correct. possibly someone is using a strip made by
        ** some other program. Tough luck!
        */
        if (i != (nsegment+2))
        {
            PrintHeader();
            StringImage("Strip info mismatch in GIF comment ext.!");
            exit(1);
        }

        for (p=digitbuf; *p != '\0'; p++)
        {
            if (isdigit(*p))
            {
                n=(*p-'0');
                bwidth += (seg_array[n+2]-seg_array[n+1]);
            }
            else
            {
                if (*p == ':')
                {
                    rinfo.x=seg_array[11];
                    bwidth += (seg_array[12]-seg_array[11]);
                }

                if ((*p == 'A') || (*p == 'a'))
                {
                    rinfo.x=seg_array[12];
                    bwidth += (seg_array[13]-seg_array[12]);
                }
                if ((*p == 'P') || (*p == 'p'))
                {
                    rinfo.x=seg_array[13];
                    bwidth += (seg_array[14]-seg_array[13]);
                }
                if (*p == ',')
                {
                    rinfo.x=seg_array[14];
                    bwidth += (seg_array[15]-seg_array[14]);
                }
                if (*p == '-')
                {
                    rinfo.x=seg_array[15];
                    bwidth += (seg_array[16]-seg_array[15]);
                }
            }
        }
        bheight=strip_image->rows;
    }
    else
    {
        PrintHeader();
        StringImage("No info about strip found in GIF comment ext.!");
        exit(1);
    }
}
    base_image= CreateBaseImage (bwidth,bheight,0,0,0,DirectClass);

    if (base_image == (Image *) NULL)
    {
        PrintHeader();
        StringImage("Unable to create base image!");
        exit(1);
    }

if (digit_info->use_strip == False)
{
    for (p=digitbuf; *p != '\0'; p++)
    {
        *tmpbuf='\0';
        if(isdigit(*p))
            (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                g_sZ_ibase,digit_info->ddhead,ImagePrefix[(int)*p-'0']);
        else
        {
            if (*p == ':')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"colon");
            if ((*p == 'A') || (*p == 'a'))
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"am");
            if ((*p == 'P') || (*p == 'p'))
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"pm");
            if (*p == ',')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"comma");
            if (*p == '-')
                (void) sprintf(tmpbuf,GIF_PATH_FMT ".gif",
                    g_sZ_ibase,digit_info->ddhead,"dash");
        }

        sub_image=ReadImage(tmpbuf);
        if (sub_image != (Image *) NULL)
        {
            FlattenImage(base_image,sub_image,ReplaceCompositeOp,
                base_width,0);
            base_width += sub_image->columns;
            DestroyAnyImageStruct(&sub_image);
        }
        else
        {
            PrintHeader();
            StringImage(" FAILED to combine digit images!");
            exit(1);
        }
    }
}
else
{
   rinfo.y=0;
   rinfo.width=15;
   rinfo.height=strip_image->rows;
    for (p=digitbuf; *p != '\0'; p++)
    {
        *tmpbuf='\0';
        if (isdigit(*p))
        {
            n=(*p-'0');
            rinfo.x=seg_array[n+1];
            rinfo.width=seg_array[n+2]-seg_array[n+1];
        }
        else
        {
            if (*p == ':')
            {
                rinfo.x=seg_array[11];
                rinfo.width=seg_array[12]-seg_array[11];
            }
            if ((*p == 'A') || (*p == 'a'))
            {
                rinfo.x=seg_array[12];
                rinfo.width=seg_array[13]-seg_array[12];
            }
            if ((*p == 'P') || (*p == 'p'))
            {
                rinfo.x=seg_array[13];
                rinfo.width=seg_array[14]-seg_array[13];
            }
            if (*p == ',')
            {
                rinfo.x=seg_array[14];
                rinfo.width=seg_array[15]-seg_array[14];
            }
            if (*p == '-')    
            {
                rinfo.x=seg_array[15];
                rinfo.width=seg_array[16]-seg_array[15];
            }    
        }

        sub_image=CropImage(strip_image,&rinfo);
        if (sub_image != (Image *) NULL)
        {
            FlattenImage(base_image,sub_image,ReplaceCompositeOp, base_width,0);
            base_width += sub_image->columns;
            DestroyAnyImageStruct(&sub_image); 
        }
        else
        {
            PrintHeader();
            StringImage("Failed to extract image from strip!");
            exit(1);
        }    
    } 
}
    return(base_image);
}

void WriteCounterImage(digitbuf,digit_info,frame_info)
char
    *digitbuf;
DigitInfo
    *digit_info;
FrameInfo
    *frame_info;
{
   Image
        *image;


   Debug2(" ,,,, ft=%d",frame_info->width,0);
   if (digit_info->display_type == SHOW_GIF_FILE)
   {
       Debug2("Displaying GIF file=\"%s\"",digitbuf,0);
       image=ReadImage(digitbuf);
   }
   else
   {
        image=CombineImages(digitbuf,digit_info);
   }

   if (image != (Image *) NULL)
   {
        MogrifyImage(&image,digit_info,frame_info);
        PrintHeader();
        (void) WriteGIFImage (image, (char *)NULL);
   }
   else
   {
        PrintHeader();
        StringImage("Failed! Check DigitDir in config.h or dd in QUERY_STRING");
   }


   exit(0);
}


/*
** something went wrong..write the built in GIF image to stdout
*/

void SendErrorImage (bits, length)
unsigned char
    *bits;
int
    length;
{
    register unsigned char
        *p;

    register int
        i;

    p = bits;
    for (i=0; i < length; i++)
    {
        (void) fputc((char) *p, stdout);
        (void) fflush (stdout);
        p++;
    }
}

/* display digital time */
void displayTime(di,fi)
DigitInfo
    *di;
FrameInfo
    *fi;
{
    time_t
        daytime,
        tm;

    struct tm
        *ptm=(struct tm *) NULL;

    long
        diff;   /* in seconds */

    char
        ampm[2],
        hour[10],
        min[10],
        digit_buf[1024];

    int
        min_dig1,
        min_dig2;

    if (di->ub == False)
    {
        tm=time(NULL);
        if (*di->time_z != '\0')
        {
            /* no more TZ, 03-26-1996 */
            diff=checkTimezone(di->time_z);
            ptm=gmtime(&tm);
/*          Allow for UTC not being available - could make this specific to */
/*          VMS < 7.0, but ANSI standard does allow gmtime to return NULL   */
/*          and the following line will not be executed unless it is NULL   */
            if ( ! ptm ) ptm = localtime( &tm );
#ifdef HAVE_MKTIME
            daytime=mktime(ptm);
#else
            daytime=netMktime(ptm);
#endif
            daytime +=diff;
            ptm=localtime(&daytime);  
            Debug2("TIME GMT OFFSET=%s",asctime(ptm),0);
        }
        else
        {
            Debug2("No timezone specified",0,0);
            ptm=localtime(&tm);
        }

        if (di->time_format == 12)
        {
            if (ptm->tm_hour < 12)
                (void) strcpy(ampm,"A");
            else
                (void) strcpy(ampm,"P");

            if (ptm->tm_hour > 12)
                ptm->tm_hour=ptm->tm_hour-12;

            if (ptm->tm_hour == 0)
                ptm->tm_hour=12;
        }

        /* taking off strftime, 01-13-95 */
        (void) sprintf(hour,"%d",ptm->tm_hour);

        /* keep leading zeros in minutes */
        min_dig1=(ptm->tm_min - (ptm->tm_min % 10)) / 10;
        min_dig2=ptm->tm_min % 10;

        (void) sprintf(min,"%d%d",min_dig1,min_dig2);

        if (di->time_format == 12)
            (void) sprintf(digit_buf,"%s:%s%s",hour,min,ampm);
        else
        {
            (void) sprintf(digit_buf,"%s:%s",hour,min);
        }
    }
    else
        (void) strcpy(digit_buf,"88888");

    WriteCounterImage(digit_buf,di,fi);

    /* we won't be here */
}


/* display date */
void displayDate(di,fi)
DigitInfo
    *di;
FrameInfo
    *fi;
{
    time_t
        daytime,
        tm;

    struct tm
        *ptm=(struct tm *) NULL;

    long
        diff;   /* in seconds */

    char
        buf[1024];

    int
        mon_dig1,
        mon_dig2,
        day_dig1,
        day_dig2,
        year_dig1,
        year_dig2;

    int
        year_dig=2000,
        y2k=0;

    if (di->ub == False)
    {
        tm=time(NULL);
        if (*di->time_z != '\0')
        {
            diff=checkTimezone(di->time_z);
            ptm=gmtime(&tm);
#ifdef HAVE_MKTIME
            daytime=mktime(ptm);
#else
            daytime=netMktime(ptm);
#endif
            daytime +=diff;
            ptm=localtime(&daytime);  
        }
        else
        {
            Debug2("No timezone specified",0,0);
            ptm=localtime(&tm);
        }
        ptm->tm_mon++;
        /*
        ** padding, saw in xdaliclock
        */
        mon_dig1=(ptm->tm_mon-(ptm->tm_mon % 10)) / 10;
        mon_dig2=ptm->tm_mon % 10;
        
        day_dig1=(ptm->tm_mday-(ptm->tm_mday % 10)) / 10;
        day_dig2=ptm->tm_mday % 10;

        /*
        ** year 2000+ hack. asked by Cris Johnson (johnson@isn.dac.neu.edu)
        */
        if (ptm->tm_year >= 100)    
        {
            year_dig= 1900+ptm->tm_year;
            y2k=1;
        }

         year_dig1=(ptm->tm_year-(ptm->tm_year % 10)) / 10;
         year_dig2=ptm->tm_year % 10;

         switch (di->date_format)
         {

                case DATE_MMDDYY:
                default:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                mon_dig1,mon_dig2,day_dig1,day_dig2,year_dig1,year_dig2);
                    else
                    (void) sprintf(buf,"%d%d-%d%d-%d",
                mon_dig1,mon_dig2,day_dig1,day_dig2,year_dig);
                    break;
                }

                case DATE_DDMMYY:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                day_dig1,day_dig2,mon_dig1,mon_dig2,year_dig1,year_dig2);
                    else
                    (void) sprintf(buf,"%d%d-%d%d-%d",
                day_dig1,day_dig2,mon_dig1,mon_dig2,year_dig);
                    break;
                }

                case DATE_YYMMDD:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                year_dig1,year_dig2,mon_dig1,mon_dig2,day_dig1,day_dig2);
                    else
                    (void) sprintf(buf,"%d-%d%d-%d%d",
                year_dig,mon_dig1,mon_dig2,day_dig1,day_dig2);

                    break;
                }

                case DATE_YYDDMM:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                year_dig1,year_dig2,day_dig1,day_dig2,mon_dig1,mon_dig2);
                    else
                    (void) sprintf(buf,"%d-%d%d-%d%d",
                year_dig,day_dig1,day_dig2,mon_dig1,mon_dig2);
                    break;
                }

                case DATE_MMYYDD:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                mon_dig1,mon_dig2,year_dig1,year_dig2,day_dig1,day_dig2);
                    else
                    (void) sprintf(buf,"%d%d-%d-%d%d",
                mon_dig1,mon_dig2,year_dig,day_dig1,day_dig2);
                    break;
                }

                case DATE_DDYYMM:
                {
                    if (!y2k)
                    (void) sprintf(buf,"%d%d-%d%d-%d%d",
                day_dig1,day_dig2,year_dig1,year_dig2,mon_dig1,mon_dig2);
                    else
                    (void) sprintf(buf,"%d%d-%d-%d%d",
                day_dig1,day_dig2,year_dig,mon_dig1,mon_dig2);
                    break;
                }
         }  /* switch */
    }
    else
    {
        (void) strcpy(buf,"88888");
    }
    
    WriteCounterImage(buf,di,fi);

    /* we won't be here */
}

