/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPSearchResults
implements Enumeration {
    private int current = 0;
    private Vector entries = new Vector();
    private LDAPSearchListener resultSource;
    private boolean searchComplete = true;
    private LDAPConnection connectionToClose = null;
    private boolean persistentSearch = false;
    private Vector cacheEntries;
    private boolean firstResult = false;

    public LDAPSearchResults() {
        this.cacheEntries = null;
    }

    LDAPSearchResults(Vector vector) {
        this.cacheEntries = (Vector)vector.clone();
    }

    void add(JDAPProtocolOp jDAPProtocolOp) {
        if (jDAPProtocolOp instanceof JDAPSearchResponse) {
            this.add((JDAPSearchResponse)jDAPProtocolOp);
            return;
        }
        if (jDAPProtocolOp instanceof JDAPSearchResultReference) {
            this.add((JDAPSearchResultReference)jDAPProtocolOp);
        }
    }

    void add(JDAPSearchResponse jDAPSearchResponse) {
        LDAPAttribute[] lDAPAttributeArray = jDAPSearchResponse.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = lDAPAttributeArray != null ? new LDAPAttributeSet(lDAPAttributeArray) : new LDAPAttributeSet();
        String string = jDAPSearchResponse.getObjectName();
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        this.entries.addElement(lDAPEntry);
    }

    void add(JDAPSearchResultReference jDAPSearchResultReference) {
        String[] stringArray = jDAPSearchResultReference.getUrls();
        if (stringArray == null) {
            return;
        }
        this.entries.addElement(new LDAPReferralException(null, 0, stringArray));
    }

    void associate(LDAPSearchListener lDAPSearchListener) {
        this.resultSource = lDAPSearchListener;
        this.searchComplete = false;
    }

    void associatePersistentSearch(LDAPSearchListener lDAPSearchListener) {
        this.resultSource = lDAPSearchListener;
        this.persistentSearch = true;
        this.searchComplete = false;
        this.firstResult = true;
    }

    void closeOnCompletion(LDAPConnection lDAPConnection) {
        if (this.searchComplete) {
            try {
                lDAPConnection.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                return;
            }
        }
        this.connectionToClose = lDAPConnection;
    }

    void quicksort(LDAPEntry[] lDAPEntryArray, LDAPEntryComparator lDAPEntryComparator, int n, int n2) {
        if (n >= n2) {
            return;
        }
        LDAPEntry lDAPEntry = lDAPEntryArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (lDAPEntryComparator.isGreater(lDAPEntryArray[--n4], lDAPEntry)) {
                continue;
            }
            while (lDAPEntryComparator.isGreater(lDAPEntry, lDAPEntryArray[++n3])) {
            }
            if (n3 >= n4) break;
            LDAPEntry lDAPEntry2 = lDAPEntryArray[n3];
            lDAPEntryArray[n3] = lDAPEntryArray[n4];
            lDAPEntryArray[n4] = lDAPEntry2;
        }
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n, n4);
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n4 + 1, n2);
    }

    public synchronized void sort(LDAPEntryComparator lDAPEntryComparator) {
        while (!this.searchComplete) {
            this.fetchResult();
        }
        int n = this.entries.size();
        if (n <= 0) {
            return;
        }
        Object[] objectArray = new LDAPEntry[n];
        this.entries.copyInto(objectArray);
        this.quicksort((LDAPEntry[])objectArray, lDAPEntryComparator, 0, n - 1);
        this.entries.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.entries.addElement(objectArray[n2]);
            ++n2;
        }
        this.current = 0;
    }

    public LDAPEntry next() throws LDAPReferralException {
        Object object = this.nextElement();
        if (object instanceof LDAPReferralException) {
            throw (LDAPReferralException)object;
        }
        if (object instanceof LDAPEntry) {
            return (LDAPEntry)object;
        }
        return null;
    }

    public Object nextElement() {
        if (this.cacheEntries == null && !this.persistentSearch && this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        if (this.current < this.entries.size()) {
            ++this.current;
            Object e = this.entries.elementAt(this.current - 1);
            this.entries.setElementAt(null, this.current - 1);
            return e;
        }
        return null;
    }

    public boolean hasMoreElements() {
        if (this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        return this.current < this.entries.size();
    }

    int getCount() {
        return this.entries.size();
    }

    int getID() {
        if (this.resultSource == null || this.searchComplete) {
            return -1;
        }
        return this.resultSource.getID();
    }

    void abandon() {
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            this.searchComplete = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fetchResult() {
        if (this.cacheEntries != null && this.current < this.cacheEntries.size() - 1) {
            LDAPEntry lDAPEntry = (LDAPEntry)this.cacheEntries.elementAt(this.current + 1);
            LDAPEntry lDAPEntry2 = new LDAPEntry(lDAPEntry.getDN(), lDAPEntry.getAttributeSet());
            this.entries.addElement(lDAPEntry2);
            return;
        }
        if (this.resultSource == null) {
            return;
        }
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            if (this.searchComplete || this.firstResult) {
                this.firstResult = false;
                return;
            }
            JDAPMessage jDAPMessage = this.resultSource.nextResult();
            if (jDAPMessage == null) {
                this.searchComplete = true;
                if (this.connectionToClose == null) return;
                try {
                    this.connectionToClose.disconnect();
                }
                catch (LDAPException lDAPException) {}
            } else {
                JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
                if (jDAPProtocolOp instanceof JDAPSearchResponse) {
                    this.add((JDAPSearchResponse)jDAPProtocolOp);
                } else {
                    this.add(jDAPProtocolOp);
                }
                return;
            }
            this.connectionToClose = null;
            return;
        }
    }
}

