/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.DeserializationException;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.IdHashtable;
import netscape.util.Vector;

public class BariumArchiveLoader {
    static final String classVersionsKey = "classVersions";
    static final String classTablesKey = "classTables";
    static final String fieldNamesKey = "fieldNames";
    static final String fieldTypesKey = "fieldTypes";
    static final String instancesKey = "instances";
    static final String classNameKey = "class";
    static final String rootInstancesKey = "rootInstances";
    Archive archive;
    Hashtable archiveDict;
    Hashtable allVersions;
    IdHashtable idForName;
    String[] nameForId;

    public BariumArchiveLoader(Archive archive) {
        this.archive = archive;
    }

    public void readASCII(InputStream inputStream) throws CodingException, DeserializationException, IOException {
        Deserializer deserializer = null;
        if (inputStream instanceof Deserializer) {
            deserializer = (Deserializer)inputStream;
        }
        this.idForName = new IdHashtable(true);
        if (deserializer == null) {
            deserializer = new Deserializer(inputStream);
        }
        this.archiveDict = (Hashtable)deserializer.readObject();
        this.loadVersions();
        this.loadClassTables();
        this.loadInstanceData();
        this.loadRoots();
    }

    void loadVersions() {
        Hashtable hashtable = (Hashtable)this.archiveDict.get((Object)classVersionsKey);
        if (hashtable == null) {
            return;
        }
        this.allVersions = new Hashtable(hashtable.count());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get((Object)string);
            int n = Integer.parseInt(string2);
            this.allVersions.put((Object)string, (Object)new Integer(n));
        }
    }

    void loadClassTables() throws CodingException {
        Hashtable hashtable = (Hashtable)this.archiveDict.get((Object)classTablesKey);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get((Object)string);
            Object[] objectArray = (Object[])hashtable2.get((Object)fieldNamesKey);
            String[] stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, stringArray.length);
            Object[] objectArray2 = (Object[])hashtable2.get((Object)fieldTypesKey);
            byte[] byArray = BariumArchiveLoader.fieldTypesForNames(objectArray2);
            ClassInfo classInfo = new ClassInfo(string);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                classInfo.addField(stringArray[n2], byArray[n2]);
                ++n2;
            }
            this.guessAtVersions(string, classInfo);
            ClassTable classTable = new ClassTable(this.archive, classInfo);
            this.archive.addClassTable(classTable);
        }
    }

    void guessAtVersions(String string, ClassInfo classInfo) {
        Integer n = (Integer)this.allVersions.get((Object)string);
        if (n != null) {
            classInfo.addClass(string, n.intValue());
        }
        Vector vector = new Vector();
        try {
            Class<?> clazz = Class.forName(string);
            while (clazz != null) {
                vector.addElement((Object)clazz.getName());
                clazz = clazz.getSuperclass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("unable to find class: " + string);
            return;
        }
        int n2 = vector.count();
        while (--n2 > 0) {
            string = (String)vector.elementAt(n2);
            n = (Integer)this.allVersions.get((Object)string);
            if (n == null) continue;
            classInfo.addClass(string, n.intValue());
        }
    }

    static byte[] fieldTypesForNames(Object[] objectArray) throws CodingException {
        int n = objectArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2];
            byArray[n2] = BariumArchiveLoader.typeForName(string);
            ++n2;
        }
        return byArray;
    }

    static byte typeForName(String string) throws CodingException {
        if ((string = string.toLowerCase()).equals("boolean")) {
            return 0;
        }
        if (string.equals("byte")) {
            return 4;
        }
        if (string.equals("short")) {
            return 6;
        }
        if (string.equals("int")) {
            return 8;
        }
        if (string.equals("long")) {
            return 10;
        }
        if (string.equals("float")) {
            return 12;
        }
        if (string.equals("double")) {
            return 14;
        }
        if (string.equals("string")) {
            return 16;
        }
        if (string.equals("byte_array")) {
            return 5;
        }
        if (string.equals("object")) {
            return 18;
        }
        if (string.equals("object_array")) {
            return 19;
        }
        throw new CodingException("unknown type name: " + string);
    }

    void loadInstanceData() throws CodingException {
        int n;
        ClassTable classTable;
        Hashtable hashtable;
        String string;
        Hashtable hashtable2 = (Hashtable)this.archiveDict.get((Object)instancesKey);
        if (hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable = (Hashtable)hashtable2.get((Object)string);
            if (this.idForName.get(string) != 0) {
                throw new CodingException("duplicate instance name: " + string);
            }
            String string2 = (String)hashtable.get((Object)classNameKey);
            if (string2 == null || string2.equals("")) {
                throw new CodingException("missing className for instance: " + string);
            }
            classTable = this.archive.classTableForName(string2);
            if (classTable == null) {
                throw new CodingException("bad class name for instance: " + string);
            }
            n = classTable.newIdentifier();
            this.idForName.putKnownAbsent(string, n);
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = this.idForName.get(string);
            classTable = this.archive.tableForId[n];
            int n2 = this.archive.rowForId[n];
            hashtable = (Hashtable)hashtable2.get((Object)string);
            this.loadRow(classTable, n2, hashtable);
        }
    }

    void loadRow(ClassTable classTable, int n, Hashtable hashtable) throws CodingException {
        int n2 = 0;
        while (n2 < classTable.fieldCount) {
            Object object = hashtable.get((Object)classTable.fieldNames[n2]);
            if (object instanceof Object[]) {
                this.setColumnFromArray(classTable, n, n2, (Object[])object);
            } else if (object instanceof String && !((String)object).equals("")) {
                this.setColumnFromString(classTable, n, n2, (String)object);
            }
            ++n2;
        }
    }

    void setColumnFromArray(ClassTable classTable, int n, int n2, Object[] objectArray) throws CodingException {
        if (classTable.fieldTypes[n2] != 19) {
            throw new CodingException("bad data for field " + classTable.fieldNames[n2]);
        }
        int[] nArray = new int[objectArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4;
            nArray[n3] = n4 = this.idForName.get(objectArray[n3]);
            ++n3;
        }
        classTable.setIdentifierArrayAt(n, n2, nArray);
    }

    void setColumnFromString(ClassTable classTable, int n, int n2, String string) throws NumberFormatException, CodingException {
        switch (classTable.fieldTypes[n2]) {
            case 0: {
                if (string.equalsIgnoreCase("true")) {
                    classTable.setBooleanAt(n, n2, true);
                    return;
                }
                if (string.equalsIgnoreCase("false")) {
                    classTable.setBooleanAt(n, n2, false);
                    return;
                }
                throw new CodingException("Invalid boolean value");
            }
            case 4: {
                classTable.setByteAt(n, n2, (byte)Integer.parseInt(string));
                return;
            }
            case 6: {
                classTable.setShortAt(n, n2, (short)Integer.parseInt(string));
                return;
            }
            case 8: {
                classTable.setIntAt(n, n2, Integer.parseInt(string));
                return;
            }
            case 10: {
                classTable.setLongAt(n, n2, Long.parseLong(string));
                return;
            }
            case 12: {
                classTable.setFloatAt(n, n2, Float.valueOf(string).floatValue());
                return;
            }
            case 14: {
                classTable.setDoubleAt(n, n2, Double.valueOf(string).doubleValue());
                return;
            }
            case 16: {
                classTable.setStringAt(n, n2, string);
                return;
            }
            case 5: {
                classTable.setByteArrayAt(n, n2, this.bytesFromString(string));
                return;
            }
            case 18: {
                classTable.setIdentifierAt(n, n2, this.idForName.get(string));
                return;
            }
        }
        throw new CodingException("unknown type " + classTable.fieldTypes[n2]);
    }

    /*
     * Unable to fully structure code
     */
    byte[] bytesFromString(String var1_1) {
        if (var1_1 == null || var1_1.equals("")) {
            return null;
        }
        var3_2 = var1_1.length();
        var7_3 = new byte[var3_2 / 2 + 1];
        var2_4 = 0;
        var5_5 = 0;
        ** GOTO lbl16
        {
            if (!Character.isSpace(var6_7 = var1_1.charAt(var2_4++))) {
                if (var2_4 >= var3_2) {
                    throw new NumberFormatException("bad byte string");
                }
                var4_6 = this.nibbleForHexChar(var6_7);
                var6_7 = var1_1.charAt(var2_4++);
                var7_3[var5_5++] = (byte)((var4_6 << 4) + this.nibbleForHexChar(var6_7));
            }
            do {
                if (var2_4 < var3_2) continue block0;
lbl16:
                // 2 sources

            } while (var2_4 < var3_2);
        }
        var8_8 = new byte[var5_5];
        System.arraycopy(var7_3, 0, var8_8, 0, var5_5);
        return var8_8;
    }

    int nibbleForHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new NumberFormatException("bad byte string");
    }

    void loadRoots() throws CodingException {
        Object[] objectArray = (Object[])this.archiveDict.get((Object)rootInstancesKey);
        if (objectArray == null || objectArray.length == 0) {
            throw new CodingException("no root instances");
        }
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            int n2 = string == null || string.equals("") ? 0 : this.idForName.get(string);
            if (n2 == 0) {
                throw new CodingException("unknown root instance " + string);
            }
            this.archive.addRootIdentifier(n2);
            ++n;
        }
    }
}

