/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import netscape.ldap.ber.stream.BERSequence;

public class LDAPControl
implements Cloneable {
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String SORTRESPONSE = "1.2.840.113556.1.4.474";
    public static final String PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    public static final String ENTRYCHANGED = "2.16.840.1.113730.3.4.7";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value;

    public LDAPControl() {
    }

    public LDAPControl(String string, boolean bl, byte[] byArray) {
        this.m_oid = string;
        this.m_critical = bl;
        this.m_value = byArray;
    }

    public String getID() {
        return this.m_oid;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public Object clone() {
        byte[] byArray = null;
        if (this.m_value != null) {
            byArray = new byte[this.m_value.length];
            int n = 0;
            while (n < this.m_value.length) {
                byArray[n] = this.m_value[n];
                ++n;
            }
        }
        LDAPControl lDAPControl = new LDAPControl(this.m_oid, this.m_critical, byArray);
        return lDAPControl;
    }

    protected byte[] flattenBER(BERSequence bERSequence) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            bERSequence.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

