static char rcsid[] = "$Id: harvest.c,v 1.7 1995/02/04 01:37:52 hardy Exp $";
/*
 *  harvest.c - Routines specific to the Harvest installation
 *
 *  Darren Hardy, hardy@cs.colorado.edu, December 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder. 
 *  
 *  This copyright notice applies to all code in Harvest other than
 *  subsystems developed elsewhere, which contain other copyright notices
 *  in their source text.
 *  
 *  The Harvest software was developed by the Internet Research Task
 *  Force Research Group on Resource Discovery (IRTF-RD).  The Harvest
 *  software may be used for academic, research, government, and internal
 *  business purposes without charge.  If you wish to sell or distribute
 *  the Harvest software to commercial clients or partners, you must
 *  license the software.  See
 *  http://harvest.cs.colorado.edu/harvest/copyright,licensing.html#licensing.
 *  
 *  The Harvest software is provided ``as is'', without express or
 *  implied warranty, and with no support nor obligation to assist in its
 *  use, correction, modification or enhancement.  We assume no liability
 *  with respect to the infringement of copyrights, trade secrets, or any
 *  patents, and are not responsible for consequential damages.  Proper
 *  use of the Harvest software is entirely the responsibility of the user.
 *  
 *  For those who are using Harvest for non-commercial purposes, you may
 *  make derivative works, subject to the following constraints:
 *  
 *  - You must include the above copyright notice and these accompanying 
 *    paragraphs in all forms of derivative works, and any documentation 
 *    and other materials related to such distribution and use acknowledge 
 *    that the software was developed at the above institutions.
 *  
 *  - You must notify IRTF-RD regarding your distribution of the 
 *    derivative work.
 *  
 *  - You must clearly notify users that your are distributing a modified 
 *    version and not the original Harvest software.
 *  
 *  - Any derivative product is also subject to the restrictions of the 
 *    copyright, including distribution and use limitations.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/param.h>
#include "util.h"

#define DEFAULT_HARVEST_HOME "/usr/local/harvest"

/*
 *  harvest_bindir() - Returns a static buffer that contains the 
 *  pathname that contains the binaries for Harvest.
 */
char *harvest_bindir()
{
	static char bindir[MAXPATHLEN + 1];
	char *s;

	if ((s = getenv("HARVEST_HOME")) != NULL)
		sprintf(bindir, "%s/bin", s);
	else
		sprintf(bindir, "%s/bin", DEFAULT_HARVEST_HOME);
	return (bindir);
}

/*
 *  harvest_libdir() - Returns a static buffer that contains the 
 *  pathname that contains the libraries for Harvest.
 */
char *harvest_libdir()
{
	static char libdir[MAXPATHLEN + 1];
	char *s;

	if ((s = getenv("HARVEST_HOME")) != NULL)
		sprintf(libdir, "%s/lib", s);
	else
		sprintf(libdir, "%s/lib", DEFAULT_HARVEST_HOME);
	return (libdir);
}

/*
 *  harvest_topdir() - Returns a static buffer that contains the 
 *  pathname that contains the libraries for Harvest.
 */
char *harvest_topdir()
{
	static char topdir[MAXPATHLEN + 1];
	char *s;

	if ((s = getenv("HARVEST_HOME")) != NULL)
		sprintf(topdir, "%s", s);
	else
		sprintf(topdir, "%s", DEFAULT_HARVEST_HOME);
	return (topdir);
}

/*
 *  add_harvest_to_path() - If xtra is not-NULL, then it will
 *  add harvest_libdir() + xtra to the path as well.  For example,
 *  a Gatherer process would call:
 *              add_harvest_to_path("gatherer:")
 *  to add $harvest_libdir/ and $harvest_libdir/gatherer
 */
void harvest_add_path(xtra)
char *xtra;
{
	char *s = getenv("PATH"), *newpath, *oldpath, *q;
	char *tmpxtra;

	if (s == NULL)
		fatal("This process does not have a PATH environment variable");
	newpath = xmalloc(strlen(s) + BUFSIZ);
	sprintf(newpath, "PATH=%s", s);
	sprintf(newpath + strlen(newpath), ":%s", harvest_bindir());
	if (xtra != NULL) {
		tmpxtra = strdup(xtra);
		q = strtok(tmpxtra, ":");
		while (q != NULL) {
			sprintf(newpath + strlen(newpath), ":%s/%s",
				harvest_libdir(), q);
			q = strtok(NULL, ":");
		}
		xfree(tmpxtra);
	}
#ifdef DEBUG
	log("Adding new PATH to environment: %s\n", newpath);
#endif
	(void) putenv(newpath);
}
