/************************************************************************/
/*                                                                      */
/*                Centre for Speech Technology Research                 */
/*                     University of Edinburgh, UK                      */
/*                       Copyright (c) 1996,1997                        */
/*                        All Rights Reserved.                          */
/*                                                                      */
/*  Permission to use, copy, modify, distribute this software and its   */
/*  documentation for research, educational and individual use only, is */
/*  hereby granted without fee, subject to the following conditions:    */
/*   1. The code must retain the above copyright notice, this list of   */
/*      conditions and the following disclaimer.                        */
/*   2. Any modifications must be clearly marked as such.               */
/*   3. Original authors' names are not deleted.                        */
/*  This software may not be used for commercial purposes without       */
/*  specific prior written permission from the authors.                 */
/*                                                                      */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
/*  THIS SOFTWARE.                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                 Author: Paul Taylor (pault@cstr.ed.ac.uk)            */
/*                   Date: Fri May  9 1997                              */
/* -------------------------------------------------------------------  */
/* Examples of Generation of Acoustic Feature Vectors from Waveforms    */
/*                                                                      */
/************************************************************************/

#include "sigpr/EST_sig2fv.h"

/**@name sig2fv:example
  * 
  * Some examples of track manipulations.
  *
  * @see EST_Track
  * @see EST_TrackMap:example
  * @see EST_TMatrix
  * @see EST_TMatrix:example
  */
//@{

int main(void)

{
/*    EST_StrList base_list;
    EST_StrList delta_list;
    EST_StrList acc_list;

    //@{ code

    // read in a waveform
    EST_Wave sig;
    EST_Wave fv;
    float shift = 0.01;
    float length = 0.02;

    sig.load("kdt_001.wav");

    // using fixed frame analysis first:
    // lets do simple lpc analysis

    base_list.append("lpc");

    // call fixed function
    sig2fv_fixed(sig, fv, op, base_list, delta_list, acc_list, shift, length);

    //@} code
*/

}

//@}
