
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                 Centre for Speech Technology Research                  \\
 //                      University of Edinburgh, UK                       \\
 //                        Copyright (c) 1996,1997                         \\
 //                         All Rights Reserved.                           \\
 //   Permission to use, copy, modify, distribute this software and its    \\
 //   documentation for research, educational and individual use only, is  \\
 //   hereby granted without fee, subject to the following conditions:     \\
 //    1. The code must retain the above copyright notice, this list of    \\
 //       conditions and the following disclaimer.                         \\
 //    2. Any modifications must be clearly marked as such.                \\
 //    3. Original authors' names are not deleted.                         \\
 //   This software may not be used for commercial purposes without        \\
 //   specific prior written permission from the authors.                  \\
 //   THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        \\
 //   DISCLAIM ALL WARRANTIES With REGARD TO THIS SOFTWARE, INCLUDING      \\
 //   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   \\
 //   SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     \\
 //   FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    \\
 //   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   \\
 //   AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          \\
 //   ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       \\
 //   THIS SOFTWARE.                                                       \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                  Author: Richard Caley (rjc@cstr.ed.ac.uk)             \\
 //  --------------------------------------------------------------------  \\
 //  A simple java wave class.                                             \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

package cstr.est.java ;

import java.lang.*;
import java.util.*;
import java.awt.*;

public class Wave
{
  int rate;
  int nsamples;
  short [] data;

  public Wave()
    {
      nsamples = 0;
      data=null;
    }

  public boolean parse(byte[] bytes)
    {
      return false;
    }

  public boolean parse(String s)
    {
      int p=0, pe=0;
      String line;
      nsamples=0;
      data=null;
      rate=0;

      pe = s.indexOf('\n', p);
      line = s.substring(p, pe);
      if (!line.equals("NIST_1A"))
	return false;
      p = pe+1;

      // skip number
      pe = s.indexOf('\n', p);
      line = s.substring(p, pe);
      p = pe+1;

      while (true)
	{
	  pe = s.indexOf('\n', p);
	  line = s.substring(p, pe);
	  
	  if (line.startsWith("end_head"))
	    break;

	  if (line.startsWith("sample_count -i "))
	    nsamples = Integer.parseInt(line.substring(16));
	  else if (line.startsWith("sample_rate -i "))
	    rate = Integer.parseInt(line.substring(15));
	  p = pe+1;
	}

      if (nsamples==0 || rate==0)
	return false;

      data = new short[nsamples];

      for(int i=0; i<nsamples; i++, p+=2)
	data[i] = (short)(s.charAt(p) + s.charAt(p+1)*255);

      return true;
    }
}
