
#include <stdio.h>
#include "jni_Skeliton.h"
#include "ling_class/EST_Skeliton.h"

static jobject skeliton_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Skeliton_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  skeliton_class = env->NewGlobalRef(myclass);
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Skeliton_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Skeliton_create_1cpp_1skeliton(JNIEnv *env, jobject self)
{
  EST_Skeliton *skeliton = new EST_Skeliton;

  // printf("create skeliton %x\n", skeliton);

  env->SetLongField(self, handle_field, (jlong)skeliton);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Skeliton_destroy_1cpp_1skeliton (JNIEnv *env, jobject self)
{
  EST_Skeliton *skeliton = (EST_Skeliton *) env->GetLongField(self, handle_field);

  // printf("destroy skeliton  %x\n", skeliton);

  delete skeliton;
  return 1;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Skeliton_cpp_1name(JNIEnv *env, jobject self)
{
  EST_Skeliton *skeliton = (EST_Skeliton *) env->GetLongField(self, handle_field);
  return  env->NewStringUTF(skeliton->name());
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Skeliton_cpp_1load (JNIEnv *env, jobject self, jstring jfilename)
{
  EST_Skeliton *skeliton = (EST_Skeliton *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *res = "";

  EST_read_status stat = skeliton->load(filename);

  env->ReleaseStringUTFChars(jfilename, filename);

  if (stat == read_format_error)
    res = "skeliton format error";
  else if (stat == read_error) 
    res = "skeliton load error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Skeliton_cpp_1save (JNIEnv *env, jobject self, jstring jfilename, jstring jformat)
{
  const EST_Skeliton *skeliton = (EST_Skeliton *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *format = env->GetStringUTFChars(jformat, 0);
  const char *res = "";

  EST_write_status stat = skeliton->save(filename,format);

  env->ReleaseStringUTFChars(jfilename, filename);
  env->ReleaseStringUTFChars(jformat, format);

  if (stat == write_error) 
    res = "skeliton save error";
  
  return  env->NewStringUTF(res);
}

