
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                 Centre for Speech Technology Research                  \\
 //                      University of Edinburgh, UK                       \\
 //                        Copyright (c) 1996,1997                         \\
 //                         All Rights Reserved.                           \\
 //   Permission to use, copy, modify, distribute this software and its    \\
 //   documentation for research, educational and individual use only, is  \\
 //   hereby granted without fee, subject to the following conditions:     \\
 //    1. The code must retain the above copyright notice, this list of    \\
 //       conditions and the following disclaimer.                         \\
 //    2. Any modifications must be clearly marked as such.                \\
 //    3. Original authors' names are not deleted.                         \\
 //   This software may not be used for commercial purposes without        \\
 //   specific prior written permission from the authors.                  \\
 //   THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        \\
 //   DISCLAIM ALL WARRANTIES With REGARD TO THIS SOFTWARE, INCLUDING      \\
 //   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   \\
 //   SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     \\
 //   FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    \\
 //   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   \\
 //   AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          \\
 //   ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       \\
 //   THIS SOFTWARE.                                                       \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                  Author: Richard Caley (rjc@cstr.ed.ac.uk)             \\
 //                    Date: Wed Feb 25 1998                               \\
 //  --------------------------------------------------------------------  \\
 //  Items in a stream. Wrapper around EST_StreamItem.                     \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\


package cstr.est.cpp ;

import java.lang.*;
import java.util.*;
import java.awt.*;

import cstr.util.*;

public class Item_Content
  implements Featured
{
  private long cpp_handle;
  private boolean mine;

  public Item_Content()
    {
      this(0L, true);
    }

  public Item_Content(long handle)
    {
      this(handle, false);
    }

  Item_Content(long handle, boolean m)
    {
      create_cpp_streamItem(handle);
      mine=m;
    }

  protected void finalize() throws Throwable
    {
      if (mine)
	destroy_cpp_streamItem();
      super.finalize();
    }

  private native String cpp_name();

  public String name()
    {
      return cpp_name();
    }

  public String getName()
    {
      return cpp_name();
    }

  private native String [] cpp_featureNames();

  public String [] featureNames()
    {
      return cpp_featureNames();
    }

  private native boolean cpp_featurePresent(String n);

  public boolean featurePresent(String n)
    {
      return cpp_featurePresent(n);
    }

  private native String cpp_getS(String n);
  
  public String getS(String n)
    {
      return cpp_getS(n);
    }

  public String getFeature(String n)
    {
      return cpp_getS(n);
    }

  private native float cpp_getF(String n);
  
  public float getF(String n)
    {
      return cpp_getF(n);
    }

  private native float cpp_getStartTime();
  
  public float getStartTime()
    {
      return cpp_getStartTime();
    }

  private native float cpp_getMidTime();
  
  public float getMidTime()
    {
      return cpp_getMidTime();
    }

  private native float cpp_getEndTime();

  public float getEndTime()
    {
      return cpp_getEndTime();
    }

  public int hashCode()
    {
      return (int)cpp_handle;
    }

  public boolean equals(Object i)
    {
      return i instanceof Item_Content && ((Item_Content)i).cpp_handle == cpp_handle;
    }

  public native long cpp_next();

  public Item_Content next()
    {
      long p = cpp_next();
      return p==0L?null:new Item_Content(p);
    }

  private native static boolean initialise_cpp();
  private native static boolean finalise_cpp();
  private native boolean create_cpp_streamItem(long handle);
  private native boolean destroy_cpp_streamItem();

  static {
    System.loadLibrary("estjava");
    if (!initialise_cpp())
	throw new ExceptionInInitializerError("Item_Content C++ fails");
  }

}
