 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon May 26 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Contour type describe the broad class of information in a            */
 /* track. Used to determine how to save them for instance.              */
 /*                                                                      */
 /************************************************************************/

/**@name EST_ContourType.h
  * Labels for tracks describing what is in there (LPC/F0/etc).
  */

//@{

#ifndef __EST_CONTOURTYPE_H__
#define __EST_CONTOURTYPE_H__

#include "EST_String.h"

/// Enumerated type of track contents types.
typedef enum EST_ContourType {
  ct_f0,
  ct_simple_f0,
  ct_abs_f0,
  ct_diff_f0,
  ct_lpc,
  ct_reflection,
  ct_lsf,
  ct_cepstrum,
  ct_area,
  ct_logarea,
  ct_power,
  ct_energy,
  ct_difference,
  ct_pitchmarks,
  ct_other,
  ct_illegal
} EST_ContourType;

class EST_Contour {
public:
  /// Return a type by name. 
  static EST_ContourType type(const char *name);

  /// Name of the type.
  static EST_String name(EST_ContourType type);
  /// Longer description.
  static EST_String description(EST_ContourType type);

  /// Return a paragraph describing the available windows.
  static EST_String options_supported(void);

  /// Return a comma separated list of the available window types.
  static EST_String options_short(void);
};

#include "EST_Track.h"

void convert(EST_Track &tr,  EST_ContourType to);

#endif
//@}
