 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                         Copyright (c) 1998                           */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/

#ifndef __CLUNITS_H__
#define __CLUNITS_H__

#include "EST_StringTrie.h"

class CLDB {
  public:
    CLDB();
    ~CLDB();

    LISP params;
    EST_StringTrie index;
    EST_StringTrie fileindex;

    EST_Item *get_unit(const EST_String &name)
	{ return (EST_Item *)index.lookup(name); }
    EST_Item *get_fileitem(const EST_String &name)
	{ return (EST_Item *)fileindex.lookup(name); }
    void load_coefs_sig(EST_Item *unit);

};

LISP cl_load_db(LISP params);
LISP acost_utt_load_coeffs(LISP utt, LISP params);
LISP make_unit_distance_tables(LISP unittypes, LISP params);
LISP ac_distance_tracks(LISP filename1, LISP filename2, LISP lweights);
void acost_dt_params(LISP params);
float ac_unit_distance(const EST_Track &unit1,
		       const EST_Track &unit2,
		       const EST_FVector wghts);

extern CLDB cldb;

#endif
