/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                 Author: Paul Taylor                                   */
/*                   Date: 6 Jan 1998                                    */
/* --------------------------------------------------------------------- */
/*                 Acoustic Unit Concatenation                           */
/*                                                                       */
/*************************************************************************/

#include "UniSyn.h"
#include "EST_inline_utils.h"
#include "siod.h"
#include "EST_sigpr.h"
#include "us_diphone.h"

void us_unit_concat(EST_Utterance &utt)
{
    EST_Relation *unit_stream;
    EST_FrameVector *frames = new EST_FrameVector;
    EST_Track *source_coef = new EST_Track;
    float window_factor;

    window_factor = get_c_float(siod_get_lval("window_factor",
					      "UniSyn: no window_factor"));

    unit_stream = utt.relation("Unit");

    concatenate_coefs(*unit_stream, *source_coef);
    window_signal(*unit_stream, *frames, window_factor);

    utt.create_relation("Frames");
    utt.create_relation("SourceCoef");

    EST_Item *item = utt.relation("Frames")->append();
    item->fset("name", "frame");
    item->fset("frame", (void *)(frames), gc_framevector);

    item = utt.relation("SourceCoef")->append();
    item->fset("name", "coef");
    item->fset("coefs", (void *)(source_coef), gc_track);
}

